<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://finance.omniva.eu/finance/erp/erpServices.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://finance.omniva.eu/finance/erp/erpServices.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Lib\OmnivaService\ClassMap::get(),
);
/**
 * Samples for Buy ServiceType
 */
$buy = new \Lib\OmnivaService\ServiceType\Buy($options);
/**
 * Sample call for BuyInvoiceExport operation/method
 */
if ($buy->BuyInvoiceExport(new \Lib\OmnivaService\StructType\BuyInvoiceReqType()) !== false) {
    print_r($buy->getResult());
} else {
    print_r($buy->getLastError());
}
/**
 * Sample call for BuyInvoices operation/method
 */
if ($buy->BuyInvoices() !== false) {
    print_r($buy->getResult());
} else {
    print_r($buy->getLastError());
}
/**
 * Sample call for BuyInvoicePdf operation/method
 */
if ($buy->BuyInvoicePdf(new \Lib\OmnivaService\StructType\BuyInvoicePdfRequest()) !== false) {
    print_r($buy->getResult());
} else {
    print_r($buy->getLastError());
}
/**
 * Sample call for BuyInvoiceRegistered operation/method
 */
if ($buy->BuyInvoiceRegistered(new \Lib\OmnivaService\StructType\BuyInvoiceRegisteredReqType()) !== false) {
    print_r($buy->getResult());
} else {
    print_r($buy->getLastError());
}
/**
 * Sample call for BuyInvoice operation/method
 */
if ($buy->BuyInvoice(new \Lib\OmnivaService\StructType\BuyInvoiceReqType()) !== false) {
    print_r($buy->getResult());
} else {
    print_r($buy->getLastError());
}
/**
 * Samples for Cost ServiceType
 */
$cost = new \Lib\OmnivaService\ServiceType\Cost($options);
/**
 * Sample call for CostReportExport operation/method
 */
if ($cost->CostReportExport(new \Lib\OmnivaService\StructType\CostReportExportRequestType()) !== false) {
    print_r($cost->getResult());
} else {
    print_r($cost->getLastError());
}
/**
 * Sample call for CostReportAttachment operation/method
 */
if ($cost->CostReportAttachment(new \Lib\OmnivaService\StructType\CostReportAttachmentRequestType()) !== false) {
    print_r($cost->getResult());
} else {
    print_r($cost->getLastError());
}
/**
 * Samples for Invoice ServiceType
 */
$invoice = new \Lib\OmnivaService\ServiceType\Invoice($options);
/**
 * Sample call for InvoiceAttachment operation/method
 */
if ($invoice->InvoiceAttachment(new \Lib\OmnivaService\StructType\InvoiceAttachmentRequestType()) !== false) {
    print_r($invoice->getResult());
} else {
    print_r($invoice->getLastError());
}
/**
 * Samples for Has ServiceType
 */
$has = new \Lib\OmnivaService\ServiceType\Has($options);
/**
 * Sample call for HasBuyInvoice operation/method
 */
if ($has->HasBuyInvoice(new \Lib\OmnivaService\StructType\BuyInvoiceReqType()) !== false) {
    print_r($has->getResult());
} else {
    print_r($has->getLastError());
}
/**
 * Samples for Account ServiceType
 */
$account = new \Lib\OmnivaService\ServiceType\Account($options);
/**
 * Sample call for AccountPlan operation/method
 */
if ($account->AccountPlan(new \Lib\OmnivaService\StructType\AccountPlanRequestType()) !== false) {
    print_r($account->getResult());
} else {
    print_r($account->getLastError());
}
/**
 * Samples for EI ServiceType
 */
$eI = new \Lib\OmnivaService\ServiceType\EI($options);
/**
 * Sample call for EInvoice operation/method
 */
if ($eI->EInvoice(new \Lib\OmnivaService\StructType\EInvoiceRequest()) !== false) {
    print_r($eI->getResult());
} else {
    print_r($eI->getLastError());
}
/**
 * Samples for Dimension ServiceType
 */
$dimension = new \Lib\OmnivaService\ServiceType\Dimension($options);
/**
 * Sample call for DimensionRegistry operation/method
 */
if ($dimension->DimensionRegistry(new \Lib\OmnivaService\StructType\DimensionRegistryRequestType()) !== false) {
    print_r($dimension->getResult());
} else {
    print_r($dimension->getLastError());
}
/**
 * Samples for Sale ServiceType
 */
$sale = new \Lib\OmnivaService\ServiceType\Sale($options);
/**
 * Sample call for SaleInvoiceBuyStatus operation/method
 */
if ($sale->SaleInvoiceBuyStatus(new \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusRequestType()) !== false) {
    print_r($sale->getResult());
} else {
    print_r($sale->getLastError());
}
/**
 * Sample call for SaleInvoiceExport operation/method
 */
if ($sale->SaleInvoiceExport(new \Lib\OmnivaService\StructType\SaleInvoiceExportReqType()) !== false) {
    print_r($sale->getResult());
} else {
    print_r($sale->getLastError());
}
/**
 * Samples for Client ServiceType
 */
$client = new \Lib\OmnivaService\ServiceType\Client($options);
/**
 * Sample call for ClientRegistry operation/method
 */
if ($client->ClientRegistry(new \Lib\OmnivaService\StructType\ClientRegistryRequestType()) !== false) {
    print_r($client->getResult());
} else {
    print_r($client->getLastError());
}
/**
 * Samples for Company ServiceType
 */
$company = new \Lib\OmnivaService\ServiceType\Company($options);
/**
 * Sample call for CompanyStatus operation/method
 */
if ($company->CompanyStatus(new \Lib\OmnivaService\StructType\CompanyStatusRequestType()) !== false) {
    print_r($company->getResult());
} else {
    print_r($company->getLastError());
}
/**
 * Samples for Reject ServiceType
 */
$reject = new \Lib\OmnivaService\ServiceType\Reject($options);
/**
 * Sample call for RejectConfirmation operation/method
 */
if ($reject->RejectConfirmation(new \Lib\OmnivaService\StructType\RejectConfirmationRequestType()) !== false) {
    print_r($reject->getResult());
} else {
    print_r($reject->getLastError());
}
/**
 * Samples for Registry ServiceType
 */
$registry = new \Lib\OmnivaService\ServiceType\Registry($options);
/**
 * Sample call for RegistryImport operation/method
 */
if ($registry->RegistryImport(new \Lib\OmnivaService\StructType\RegistryImportRequest()) !== false) {
    print_r($registry->getResult());
} else {
    print_r($registry->getLastError());
}
