<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VATRecord StructType
 * @subpackage Structs
 */
class VATRecord extends AbstractStructBase
{
    /**
     * The SumBeforeVAT
     * Meta informations extracted from the WSDL
     * - fractionDigits: 4
     * @var float
     */
    public $SumBeforeVAT;
    /**
     * The VATRate
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * @var float
     */
    public $VATRate;
    /**
     * The VATSum
     * Meta informations extracted from the WSDL
     * - fractionDigits: 4
     * @var float
     */
    public $VATSum;
    /**
     * Constructor method for VATRecord
     * @uses VATRecord::setSumBeforeVAT()
     * @uses VATRecord::setVATRate()
     * @uses VATRecord::setVATSum()
     * @param float $sumBeforeVAT
     * @param float $vATRate
     * @param float $vATSum
     */
    public function __construct($sumBeforeVAT = null, $vATRate = null, $vATSum = null)
    {
        $this
            ->setSumBeforeVAT($sumBeforeVAT)
            ->setVATRate($vATRate)
            ->setVATSum($vATSum);
    }
    /**
     * Get SumBeforeVAT value
     * @return float|null
     */
    public function getSumBeforeVAT()
    {
        return $this->SumBeforeVAT;
    }
    /**
     * Set SumBeforeVAT value
     * @param float $sumBeforeVAT
     * @return \Lib\OmnivaService\StructType\VATRecord
     */
    public function setSumBeforeVAT($sumBeforeVAT = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($sumBeforeVAT) && strlen(substr($sumBeforeVAT, strpos($sumBeforeVAT, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($sumBeforeVAT, strpos($sumBeforeVAT, '.') + 1))), __LINE__);
        }
        $this->SumBeforeVAT = $sumBeforeVAT;
        return $this;
    }
    /**
     * Get VATRate value
     * @return float|null
     */
    public function getVATRate()
    {
        return $this->VATRate;
    }
    /**
     * Set VATRate value
     * @param float $vATRate
     * @return \Lib\OmnivaService\StructType\VATRecord
     */
    public function setVATRate($vATRate = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($vATRate) && strlen(substr($vATRate, strpos($vATRate, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($vATRate, strpos($vATRate, '.') + 1))), __LINE__);
        }
        $this->VATRate = $vATRate;
        return $this;
    }
    /**
     * Get VATSum value
     * @return float|null
     */
    public function getVATSum()
    {
        return $this->VATSum;
    }
    /**
     * Set VATSum value
     * @param float $vATSum
     * @return \Lib\OmnivaService\StructType\VATRecord
     */
    public function setVATSum($vATSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($vATSum) && strlen(substr($vATSum, strpos($vATSum, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($vATSum, strpos($vATSum, '.') + 1))), __LINE__);
        }
        $this->VATSum = $vATSum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\VATRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
