<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisteredInvoiceType StructType
 * @subpackage Structs
 */
class RegisteredInvoiceType extends AbstractStructBase
{
    /**
     * The invoiceId
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 100
     * @var string
     */
    public $invoiceId;
    /**
     * The ErpDocumentNumber
     * Meta informations extracted from the WSDL
     * - documentation: Document number in ERP
     * - maxLength: 500
     * @var string
     */
    public $ErpDocumentNumber;
    /**
     * Constructor method for RegisteredInvoiceType
     * @uses RegisteredInvoiceType::setInvoiceId()
     * @uses RegisteredInvoiceType::setErpDocumentNumber()
     * @param string $invoiceId
     * @param string $erpDocumentNumber
     */
    public function __construct($invoiceId = null, $erpDocumentNumber = null)
    {
        $this
            ->setInvoiceId($invoiceId)
            ->setErpDocumentNumber($erpDocumentNumber);
    }
    /**
     * Get invoiceId value
     * @return string
     */
    public function getInvoiceId()
    {
        return $this->invoiceId;
    }
    /**
     * Set invoiceId value
     * @param string $invoiceId
     * @return \Lib\OmnivaService\StructType\RegisteredInvoiceType
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceId) && strlen($invoiceId) > 100) || (is_array($invoiceId) && count($invoiceId) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($invoiceId) ? strlen($invoiceId) : count($invoiceId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceId)), __LINE__);
        }
        $this->invoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get ErpDocumentNumber value
     * @return string|null
     */
    public function getErpDocumentNumber()
    {
        return $this->ErpDocumentNumber;
    }
    /**
     * Set ErpDocumentNumber value
     * @param string $erpDocumentNumber
     * @return \Lib\OmnivaService\StructType\RegisteredInvoiceType
     */
    public function setErpDocumentNumber($erpDocumentNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($erpDocumentNumber) && strlen($erpDocumentNumber) > 500) || (is_array($erpDocumentNumber) && count($erpDocumentNumber) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($erpDocumentNumber) ? strlen($erpDocumentNumber) : count($erpDocumentNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($erpDocumentNumber) && !is_string($erpDocumentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($erpDocumentNumber)), __LINE__);
        }
        $this->ErpDocumentNumber = $erpDocumentNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\RegisteredInvoiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
