<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegNumber StructType
 * Meta informations extracted from the WSDL
 * - documentation: Reg number of company whose status is requested
 * - maxLength: 15
 * @subpackage Structs
 */
class RegNumber extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - maxLength: 15
     * @var string
     */
    public $_;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $countryCode;
    /**
     * Constructor method for RegNumber
     * @uses RegNumber::set_()
     * @uses RegNumber::setCountryCode()
     * @param string $_
     * @param string $countryCode
     */
    public function __construct($_ = null, $countryCode = null)
    {
        $this
            ->set_($_)
            ->setCountryCode($countryCode);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Lib\OmnivaService\StructType\RegNumber
     */
    public function set_($_ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($_) && strlen($_) > 15) || (is_array($_) && count($_) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($_) ? strlen($_) : count($_)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \Lib\OmnivaService\StructType\RegNumber
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\RegNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
