<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceItemGroup StructType
 * @subpackage Structs
 */
class InvoiceItemGroup extends AbstractStructBase
{
    /**
     * The ItemEntry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ItemEntry
     * @var \Lib\OmnivaService\StructType\ItemEntry[]
     */
    public $ItemEntry;
    /**
     * The GroupEntry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: GroupEntry
     * @var \Lib\OmnivaService\StructType\GroupEntry
     */
    public $GroupEntry;
    /**
     * The groupId
     * Meta informations extracted from the WSDL
     * - use: optional
     * - maxLength: 20
     * @var string
     */
    public $groupId;
    /**
     * Constructor method for InvoiceItemGroup
     * @uses InvoiceItemGroup::setItemEntry()
     * @uses InvoiceItemGroup::setGroupEntry()
     * @uses InvoiceItemGroup::setGroupId()
     * @param \Lib\OmnivaService\StructType\ItemEntry[] $itemEntry
     * @param \Lib\OmnivaService\StructType\GroupEntry $groupEntry
     * @param string $groupId
     */
    public function __construct(array $itemEntry = array(), \Lib\OmnivaService\StructType\GroupEntry $groupEntry = null, $groupId = null)
    {
        $this
            ->setItemEntry($itemEntry)
            ->setGroupEntry($groupEntry)
            ->setGroupId($groupId);
    }
    /**
     * Get ItemEntry value
     * @return \Lib\OmnivaService\StructType\ItemEntry[]|null
     */
    public function getItemEntry()
    {
        return $this->ItemEntry;
    }
    /**
     * Set ItemEntry value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ItemEntry[] $itemEntry
     * @return \Lib\OmnivaService\StructType\InvoiceItemGroup
     */
    public function setItemEntry(array $itemEntry = array())
    {
        foreach ($itemEntry as $invoiceItemGroupItemEntryItem) {
            // validation for constraint: itemType
            if (!$invoiceItemGroupItemEntryItem instanceof \Lib\OmnivaService\StructType\ItemEntry) {
                throw new \InvalidArgumentException(sprintf('The ItemEntry property can only contain items of \Lib\OmnivaService\StructType\ItemEntry, "%s" given', is_object($invoiceItemGroupItemEntryItem) ? get_class($invoiceItemGroupItemEntryItem) : gettype($invoiceItemGroupItemEntryItem)), __LINE__);
            }
        }
        $this->ItemEntry = $itemEntry;
        return $this;
    }
    /**
     * Add item to ItemEntry value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ItemEntry $item
     * @return \Lib\OmnivaService\StructType\InvoiceItemGroup
     */
    public function addToItemEntry(\Lib\OmnivaService\StructType\ItemEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\ItemEntry) {
            throw new \InvalidArgumentException(sprintf('The ItemEntry property can only contain items of \Lib\OmnivaService\StructType\ItemEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemEntry[] = $item;
        return $this;
    }
    /**
     * Get GroupEntry value
     * @return \Lib\OmnivaService\StructType\GroupEntry|null
     */
    public function getGroupEntry()
    {
        return $this->GroupEntry;
    }
    /**
     * Set GroupEntry value
     * @param \Lib\OmnivaService\StructType\GroupEntry $groupEntry
     * @return \Lib\OmnivaService\StructType\InvoiceItemGroup
     */
    public function setGroupEntry(\Lib\OmnivaService\StructType\GroupEntry $groupEntry = null)
    {
        $this->GroupEntry = $groupEntry;
        return $this;
    }
    /**
     * Get groupId value
     * @return string|null
     */
    public function getGroupId()
    {
        return $this->groupId;
    }
    /**
     * Set groupId value
     * @param string $groupId
     * @return \Lib\OmnivaService\StructType\InvoiceItemGroup
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($groupId) && strlen($groupId) > 20) || (is_array($groupId) && count($groupId) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($groupId) ? strlen($groupId) : count($groupId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->groupId = $groupId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\InvoiceItemGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
