<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInformation StructType
 * @subpackage Structs
 */
class InvoiceInformation extends AbstractStructBase
{
    /**
     * The Type
     * @var \Lib\OmnivaService\StructType\Type
     */
    public $Type;
    /**
     * The FactorContractNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $FactorContractNumber;
    /**
     * The ContractNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $ContractNumber;
    /**
     * The DocumentName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $DocumentName;
    /**
     * The InvoiceNumber
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The InvoiceContentCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $InvoiceContentCode;
    /**
     * The InvoiceContentText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $InvoiceContentText;
    /**
     * The PaymentReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * - pattern: ([0-9])*
     * @var string
     */
    public $PaymentReferenceNumber;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $PaymentMethod;
    /**
     * The InvoiceDate
     * @var string
     */
    public $InvoiceDate;
    /**
     * The DueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DueDate;
    /**
     * The FineRatePerDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 2
     * @var float
     */
    public $FineRatePerDay;
    /**
     * The Period
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\Period
     */
    public $Period;
    /**
     * The Extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\ExtensionRecord[]
     */
    public $Extension;
    /**
     * Constructor method for InvoiceInformation
     * @uses InvoiceInformation::setType()
     * @uses InvoiceInformation::setFactorContractNumber()
     * @uses InvoiceInformation::setContractNumber()
     * @uses InvoiceInformation::setDocumentName()
     * @uses InvoiceInformation::setInvoiceNumber()
     * @uses InvoiceInformation::setInvoiceContentCode()
     * @uses InvoiceInformation::setInvoiceContentText()
     * @uses InvoiceInformation::setPaymentReferenceNumber()
     * @uses InvoiceInformation::setPaymentMethod()
     * @uses InvoiceInformation::setInvoiceDate()
     * @uses InvoiceInformation::setDueDate()
     * @uses InvoiceInformation::setFineRatePerDay()
     * @uses InvoiceInformation::setPeriod()
     * @uses InvoiceInformation::setExtension()
     * @param \Lib\OmnivaService\StructType\Type $type
     * @param string $factorContractNumber
     * @param string $contractNumber
     * @param string $documentName
     * @param string $invoiceNumber
     * @param string $invoiceContentCode
     * @param string $invoiceContentText
     * @param string $paymentReferenceNumber
     * @param string $paymentMethod
     * @param string $invoiceDate
     * @param string $dueDate
     * @param float $fineRatePerDay
     * @param \Lib\OmnivaService\StructType\Period $period
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $extension
     */
    public function __construct(\Lib\OmnivaService\StructType\Type $type = null, $factorContractNumber = null, $contractNumber = null, $documentName = null, $invoiceNumber = null, $invoiceContentCode = null, $invoiceContentText = null, $paymentReferenceNumber = null, $paymentMethod = null, $invoiceDate = null, $dueDate = null, $fineRatePerDay = null, \Lib\OmnivaService\StructType\Period $period = null, array $extension = array())
    {
        $this
            ->setType($type)
            ->setFactorContractNumber($factorContractNumber)
            ->setContractNumber($contractNumber)
            ->setDocumentName($documentName)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceContentCode($invoiceContentCode)
            ->setInvoiceContentText($invoiceContentText)
            ->setPaymentReferenceNumber($paymentReferenceNumber)
            ->setPaymentMethod($paymentMethod)
            ->setInvoiceDate($invoiceDate)
            ->setDueDate($dueDate)
            ->setFineRatePerDay($fineRatePerDay)
            ->setPeriod($period)
            ->setExtension($extension);
    }
    /**
     * Get Type value
     * @return \Lib\OmnivaService\StructType\Type|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \Lib\OmnivaService\StructType\Type $type
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setType(\Lib\OmnivaService\StructType\Type $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get FactorContractNumber value
     * @return string|null
     */
    public function getFactorContractNumber()
    {
        return $this->FactorContractNumber;
    }
    /**
     * Set FactorContractNumber value
     * @param string $factorContractNumber
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setFactorContractNumber($factorContractNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($factorContractNumber) && strlen($factorContractNumber) > 100) || (is_array($factorContractNumber) && count($factorContractNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($factorContractNumber) ? strlen($factorContractNumber) : count($factorContractNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($factorContractNumber) && !is_string($factorContractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($factorContractNumber)), __LINE__);
        }
        $this->FactorContractNumber = $factorContractNumber;
        return $this;
    }
    /**
     * Get ContractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->ContractNumber;
    }
    /**
     * Set ContractNumber value
     * @param string $contractNumber
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contractNumber) && strlen($contractNumber) > 100) || (is_array($contractNumber) && count($contractNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($contractNumber) ? strlen($contractNumber) : count($contractNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractNumber)), __LINE__);
        }
        $this->ContractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get DocumentName value
     * @return string|null
     */
    public function getDocumentName()
    {
        return $this->DocumentName;
    }
    /**
     * Set DocumentName value
     * @param string $documentName
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($documentName) && strlen($documentName) > 100) || (is_array($documentName) && count($documentName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($documentName) ? strlen($documentName) : count($documentName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentName)), __LINE__);
        }
        $this->DocumentName = $documentName;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceNumber) && strlen($invoiceNumber) > 100) || (is_array($invoiceNumber) && count($invoiceNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($invoiceNumber) ? strlen($invoiceNumber) : count($invoiceNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceContentCode value
     * @return string|null
     */
    public function getInvoiceContentCode()
    {
        return $this->InvoiceContentCode;
    }
    /**
     * Set InvoiceContentCode value
     * @param string $invoiceContentCode
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setInvoiceContentCode($invoiceContentCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceContentCode) && strlen($invoiceContentCode) > 20) || (is_array($invoiceContentCode) && count($invoiceContentCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($invoiceContentCode) ? strlen($invoiceContentCode) : count($invoiceContentCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceContentCode) && !is_string($invoiceContentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceContentCode)), __LINE__);
        }
        $this->InvoiceContentCode = $invoiceContentCode;
        return $this;
    }
    /**
     * Get InvoiceContentText value
     * @return string|null
     */
    public function getInvoiceContentText()
    {
        return $this->InvoiceContentText;
    }
    /**
     * Set InvoiceContentText value
     * @param string $invoiceContentText
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setInvoiceContentText($invoiceContentText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceContentText) && strlen($invoiceContentText) > 100) || (is_array($invoiceContentText) && count($invoiceContentText) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($invoiceContentText) ? strlen($invoiceContentText) : count($invoiceContentText)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceContentText) && !is_string($invoiceContentText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceContentText)), __LINE__);
        }
        $this->InvoiceContentText = $invoiceContentText;
        return $this;
    }
    /**
     * Get PaymentReferenceNumber value
     * @return string|null
     */
    public function getPaymentReferenceNumber()
    {
        return $this->PaymentReferenceNumber;
    }
    /**
     * Set PaymentReferenceNumber value
     * @param string $paymentReferenceNumber
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setPaymentReferenceNumber($paymentReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentReferenceNumber) && strlen($paymentReferenceNumber) > 20) || (is_array($paymentReferenceNumber) && count($paymentReferenceNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($paymentReferenceNumber) ? strlen($paymentReferenceNumber) : count($paymentReferenceNumber)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($paymentReferenceNumber) && !preg_match('/([0-9])*/', $paymentReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9])*", "%s" given', var_export($paymentReferenceNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentReferenceNumber) && !is_string($paymentReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentReferenceNumber)), __LINE__);
        }
        $this->PaymentReferenceNumber = $paymentReferenceNumber;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentMethod) && strlen($paymentMethod) > 100) || (is_array($paymentMethod) && count($paymentMethod) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($paymentMethod) ? strlen($paymentMethod) : count($paymentMethod)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get FineRatePerDay value
     * @return float|null
     */
    public function getFineRatePerDay()
    {
        return $this->FineRatePerDay;
    }
    /**
     * Set FineRatePerDay value
     * @param float $fineRatePerDay
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setFineRatePerDay($fineRatePerDay = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($fineRatePerDay) && strlen(substr($fineRatePerDay, strpos($fineRatePerDay, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($fineRatePerDay, strpos($fineRatePerDay, '.') + 1))), __LINE__);
        }
        $this->FineRatePerDay = $fineRatePerDay;
        return $this;
    }
    /**
     * Get Period value
     * @return \Lib\OmnivaService\StructType\Period|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \Lib\OmnivaService\StructType\Period $period
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setPeriod(\Lib\OmnivaService\StructType\Period $period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get Extension value
     * @return \Lib\OmnivaService\StructType\ExtensionRecord[]|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $extension
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function setExtension(array $extension = array())
    {
        foreach ($extension as $invoiceInformationExtensionItem) {
            // validation for constraint: itemType
            if (!$invoiceInformationExtensionItem instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
                throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($invoiceInformationExtensionItem) ? get_class($invoiceInformationExtensionItem) : gettype($invoiceInformationExtensionItem)), __LINE__);
            }
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Add item to Extension value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord $item
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public function addToExtension(\Lib\OmnivaService\StructType\ExtensionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
            throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Extension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
