<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceAttachmentType StructType
 * @subpackage Structs
 */
class InvoiceAttachmentType extends AbstractStructBase
{
    /**
     * The AttachmentContent
     * @var string
     */
    public $AttachmentContent;
    /**
     * The invoiceId
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $invoiceId;
    /**
     * The fileType
     * @var string
     */
    public $fileType;
    /**
     * The fileName
     * @var string
     */
    public $fileName;
    /**
     * The length
     * @var int
     */
    public $length;
    /**
     * Constructor method for InvoiceAttachmentType
     * @uses InvoiceAttachmentType::setAttachmentContent()
     * @uses InvoiceAttachmentType::setInvoiceId()
     * @uses InvoiceAttachmentType::setFileType()
     * @uses InvoiceAttachmentType::setFileName()
     * @uses InvoiceAttachmentType::setLength()
     * @param string $attachmentContent
     * @param string $invoiceId
     * @param string $fileType
     * @param string $fileName
     * @param int $length
     */
    public function __construct($attachmentContent = null, $invoiceId = null, $fileType = null, $fileName = null, $length = null)
    {
        $this
            ->setAttachmentContent($attachmentContent)
            ->setInvoiceId($invoiceId)
            ->setFileType($fileType)
            ->setFileName($fileName)
            ->setLength($length);
    }
    /**
     * Get AttachmentContent value
     * @return string|null
     */
    public function getAttachmentContent()
    {
        return $this->AttachmentContent;
    }
    /**
     * Set AttachmentContent value
     * @param string $attachmentContent
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentType
     */
    public function setAttachmentContent($attachmentContent = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentContent) && !is_string($attachmentContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentContent)), __LINE__);
        }
        $this->AttachmentContent = $attachmentContent;
        return $this;
    }
    /**
     * Get invoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->invoiceId;
    }
    /**
     * Set invoiceId value
     * @param string $invoiceId
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentType
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceId) && strlen($invoiceId) > 100) || (is_array($invoiceId) && count($invoiceId) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($invoiceId) ? strlen($invoiceId) : count($invoiceId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceId)), __LINE__);
        }
        $this->invoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get fileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->fileType;
    }
    /**
     * Set fileType value
     * @param string $fileType
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentType
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileType)), __LINE__);
        }
        $this->fileType = $fileType;
        return $this;
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentType
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param int $length
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentType
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !is_numeric($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
