<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Header StructType
 * @subpackage Structs
 */
class Header extends AbstractStructBase
{
    /**
     * The Test
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Test;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The FileId
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * @var string
     */
    public $FileId;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * @var string
     */
    public $Version;
    /**
     * The SenderId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $SenderId;
    /**
     * The ReceiverId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $ReceiverId;
    /**
     * The ContractId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $ContractId;
    /**
     * The PayeeAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * - pattern: ([0-9|A-Z])*
     * @var string
     */
    public $PayeeAccountNumber;
    /**
     * The TotalNumberInvoices
     * @var int
     */
    public $TotalNumberInvoices;
    /**
     * The TotalAmount
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * @var float
     */
    public $TotalAmount;
    /**
     * Constructor method for Header
     * @uses Header::setTest()
     * @uses Header::setDate()
     * @uses Header::setFileId()
     * @uses Header::setVersion()
     * @uses Header::setSenderId()
     * @uses Header::setReceiverId()
     * @uses Header::setContractId()
     * @uses Header::setPayeeAccountNumber()
     * @uses Header::setTotalNumberInvoices()
     * @uses Header::setTotalAmount()
     * @param string $test
     * @param string $date
     * @param string $fileId
     * @param string $version
     * @param string $senderId
     * @param string $receiverId
     * @param string $contractId
     * @param string $payeeAccountNumber
     * @param int $totalNumberInvoices
     * @param float $totalAmount
     */
    public function __construct($test = null, $date = null, $fileId = null, $version = null, $senderId = null, $receiverId = null, $contractId = null, $payeeAccountNumber = null, $totalNumberInvoices = null, $totalAmount = null)
    {
        $this
            ->setTest($test)
            ->setDate($date)
            ->setFileId($fileId)
            ->setVersion($version)
            ->setSenderId($senderId)
            ->setReceiverId($receiverId)
            ->setContractId($contractId)
            ->setPayeeAccountNumber($payeeAccountNumber)
            ->setTotalNumberInvoices($totalNumberInvoices)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get Test value
     * @return string|null
     */
    public function getTest()
    {
        return $this->Test;
    }
    /**
     * Set Test value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $test
     * @return \Lib\OmnivaService\StructType\Header
     */
    public function setTest($test = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($test)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $test, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->Test = $test;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Lib\OmnivaService\StructType\Header
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get FileId value
     * @return string|null
     */
    public function getFileId()
    {
        return $this->FileId;
    }
    /**
     * Set FileId value
     * @param string $fileId
     * @return \Lib\OmnivaService\StructType\Header
     */
    public function setFileId($fileId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fileId) && strlen($fileId) > 20) || (is_array($fileId) && count($fileId) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($fileId) ? strlen($fileId) : count($fileId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fileId) && !is_string($fileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileId)), __LINE__);
        }
        $this->FileId = $fileId;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Lib\OmnivaService\StructType\Header
     */
    public function setVersion($version = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($version) && strlen($version) > 20) || (is_array($version) && count($version) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($version) ? strlen($version) : count($version)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get SenderId value
     * @return string|null
     */
    public function getSenderId()
    {
        return $this->SenderId;
    }
    /**
     * Set SenderId value
     * @param string $senderId
     * @return \Lib\OmnivaService\StructType\Header
     */
    public function setSenderId($senderId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($senderId) && strlen($senderId) > 20) || (is_array($senderId) && count($senderId) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($senderId) ? strlen($senderId) : count($senderId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($senderId) && !is_string($senderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderId)), __LINE__);
        }
        $this->SenderId = $senderId;
        return $this;
    }
    /**
     * Get ReceiverId value
     * @return string|null
     */
    public function getReceiverId()
    {
        return $this->ReceiverId;
    }
    /**
     * Set ReceiverId value
     * @param string $receiverId
     * @return \Lib\OmnivaService\StructType\Header
     */
    public function setReceiverId($receiverId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($receiverId) && strlen($receiverId) > 20) || (is_array($receiverId) && count($receiverId) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($receiverId) ? strlen($receiverId) : count($receiverId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($receiverId) && !is_string($receiverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverId)), __LINE__);
        }
        $this->ReceiverId = $receiverId;
        return $this;
    }
    /**
     * Get ContractId value
     * @return string|null
     */
    public function getContractId()
    {
        return $this->ContractId;
    }
    /**
     * Set ContractId value
     * @param string $contractId
     * @return \Lib\OmnivaService\StructType\Header
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contractId) && strlen($contractId) > 20) || (is_array($contractId) && count($contractId) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($contractId) ? strlen($contractId) : count($contractId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractId) && !is_string($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractId)), __LINE__);
        }
        $this->ContractId = $contractId;
        return $this;
    }
    /**
     * Get PayeeAccountNumber value
     * @return string|null
     */
    public function getPayeeAccountNumber()
    {
        return $this->PayeeAccountNumber;
    }
    /**
     * Set PayeeAccountNumber value
     * @param string $payeeAccountNumber
     * @return \Lib\OmnivaService\StructType\Header
     */
    public function setPayeeAccountNumber($payeeAccountNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($payeeAccountNumber) && strlen($payeeAccountNumber) > 35) || (is_array($payeeAccountNumber) && count($payeeAccountNumber) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($payeeAccountNumber) ? strlen($payeeAccountNumber) : count($payeeAccountNumber)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($payeeAccountNumber) && !preg_match('/([0-9|A-Z])*/', $payeeAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9|A-Z])*", "%s" given', var_export($payeeAccountNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($payeeAccountNumber) && !is_string($payeeAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payeeAccountNumber)), __LINE__);
        }
        $this->PayeeAccountNumber = $payeeAccountNumber;
        return $this;
    }
    /**
     * Get TotalNumberInvoices value
     * @return int|null
     */
    public function getTotalNumberInvoices()
    {
        return $this->TotalNumberInvoices;
    }
    /**
     * Set TotalNumberInvoices value
     * @param int $totalNumberInvoices
     * @return \Lib\OmnivaService\StructType\Header
     */
    public function setTotalNumberInvoices($totalNumberInvoices = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberInvoices) && !is_numeric($totalNumberInvoices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberInvoices)), __LINE__);
        }
        $this->TotalNumberInvoices = $totalNumberInvoices;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \Lib\OmnivaService\StructType\Header
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($totalAmount) && strlen(substr($totalAmount, strpos($totalAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($totalAmount, strpos($totalAmount, '.') + 1))), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\Header
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
