<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupEntry StructType
 * @subpackage Structs
 */
class GroupEntry extends AbstractStructBase
{
    /**
     * The GroupDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $GroupDescription;
    /**
     * The Extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\ExtensionRecord[]
     */
    public $Extension;
    /**
     * The Accounting
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\AccountingRecord
     */
    public $Accounting;
    /**
     * The GroupAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 4
     * @var float
     */
    public $GroupAmount;
    /**
     * The GroupSum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 4
     * @var float
     */
    public $GroupSum;
    /**
     * The Addition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\AdditionRecord[]
     */
    public $Addition;
    /**
     * The VAT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\VATRecord
     */
    public $VAT;
    /**
     * The GroupTotal
     * Meta informations extracted from the WSDL
     * - fractionDigits: 4
     * @var float
     */
    public $GroupTotal;
    /**
     * Constructor method for GroupEntry
     * @uses GroupEntry::setGroupDescription()
     * @uses GroupEntry::setExtension()
     * @uses GroupEntry::setAccounting()
     * @uses GroupEntry::setGroupAmount()
     * @uses GroupEntry::setGroupSum()
     * @uses GroupEntry::setAddition()
     * @uses GroupEntry::setVAT()
     * @uses GroupEntry::setGroupTotal()
     * @param string $groupDescription
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $extension
     * @param \Lib\OmnivaService\StructType\AccountingRecord $accounting
     * @param float $groupAmount
     * @param float $groupSum
     * @param \Lib\OmnivaService\StructType\AdditionRecord[] $addition
     * @param \Lib\OmnivaService\StructType\VATRecord $vAT
     * @param float $groupTotal
     */
    public function __construct($groupDescription = null, array $extension = array(), \Lib\OmnivaService\StructType\AccountingRecord $accounting = null, $groupAmount = null, $groupSum = null, array $addition = array(), \Lib\OmnivaService\StructType\VATRecord $vAT = null, $groupTotal = null)
    {
        $this
            ->setGroupDescription($groupDescription)
            ->setExtension($extension)
            ->setAccounting($accounting)
            ->setGroupAmount($groupAmount)
            ->setGroupSum($groupSum)
            ->setAddition($addition)
            ->setVAT($vAT)
            ->setGroupTotal($groupTotal);
    }
    /**
     * Get GroupDescription value
     * @return string|null
     */
    public function getGroupDescription()
    {
        return $this->GroupDescription;
    }
    /**
     * Set GroupDescription value
     * @param string $groupDescription
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public function setGroupDescription($groupDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($groupDescription) && strlen($groupDescription) > 100) || (is_array($groupDescription) && count($groupDescription) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($groupDescription) ? strlen($groupDescription) : count($groupDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groupDescription) && !is_string($groupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupDescription)), __LINE__);
        }
        $this->GroupDescription = $groupDescription;
        return $this;
    }
    /**
     * Get Extension value
     * @return \Lib\OmnivaService\StructType\ExtensionRecord[]|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $extension
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public function setExtension(array $extension = array())
    {
        foreach ($extension as $groupEntryExtensionItem) {
            // validation for constraint: itemType
            if (!$groupEntryExtensionItem instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
                throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($groupEntryExtensionItem) ? get_class($groupEntryExtensionItem) : gettype($groupEntryExtensionItem)), __LINE__);
            }
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Add item to Extension value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord $item
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public function addToExtension(\Lib\OmnivaService\StructType\ExtensionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
            throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Extension[] = $item;
        return $this;
    }
    /**
     * Get Accounting value
     * @return \Lib\OmnivaService\StructType\AccountingRecord|null
     */
    public function getAccounting()
    {
        return $this->Accounting;
    }
    /**
     * Set Accounting value
     * @param \Lib\OmnivaService\StructType\AccountingRecord $accounting
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public function setAccounting(\Lib\OmnivaService\StructType\AccountingRecord $accounting = null)
    {
        $this->Accounting = $accounting;
        return $this;
    }
    /**
     * Get GroupAmount value
     * @return float|null
     */
    public function getGroupAmount()
    {
        return $this->GroupAmount;
    }
    /**
     * Set GroupAmount value
     * @param float $groupAmount
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public function setGroupAmount($groupAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($groupAmount) && strlen(substr($groupAmount, strpos($groupAmount, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($groupAmount, strpos($groupAmount, '.') + 1))), __LINE__);
        }
        $this->GroupAmount = $groupAmount;
        return $this;
    }
    /**
     * Get GroupSum value
     * @return float|null
     */
    public function getGroupSum()
    {
        return $this->GroupSum;
    }
    /**
     * Set GroupSum value
     * @param float $groupSum
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public function setGroupSum($groupSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($groupSum) && strlen(substr($groupSum, strpos($groupSum, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($groupSum, strpos($groupSum, '.') + 1))), __LINE__);
        }
        $this->GroupSum = $groupSum;
        return $this;
    }
    /**
     * Get Addition value
     * @return \Lib\OmnivaService\StructType\AdditionRecord[]|null
     */
    public function getAddition()
    {
        return $this->Addition;
    }
    /**
     * Set Addition value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\AdditionRecord[] $addition
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public function setAddition(array $addition = array())
    {
        foreach ($addition as $groupEntryAdditionItem) {
            // validation for constraint: itemType
            if (!$groupEntryAdditionItem instanceof \Lib\OmnivaService\StructType\AdditionRecord) {
                throw new \InvalidArgumentException(sprintf('The Addition property can only contain items of \Lib\OmnivaService\StructType\AdditionRecord, "%s" given', is_object($groupEntryAdditionItem) ? get_class($groupEntryAdditionItem) : gettype($groupEntryAdditionItem)), __LINE__);
            }
        }
        $this->Addition = $addition;
        return $this;
    }
    /**
     * Add item to Addition value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\AdditionRecord $item
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public function addToAddition(\Lib\OmnivaService\StructType\AdditionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\AdditionRecord) {
            throw new \InvalidArgumentException(sprintf('The Addition property can only contain items of \Lib\OmnivaService\StructType\AdditionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Addition[] = $item;
        return $this;
    }
    /**
     * Get VAT value
     * @return \Lib\OmnivaService\StructType\VATRecord|null
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @param \Lib\OmnivaService\StructType\VATRecord $vAT
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public function setVAT(\Lib\OmnivaService\StructType\VATRecord $vAT = null)
    {
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Get GroupTotal value
     * @return float|null
     */
    public function getGroupTotal()
    {
        return $this->GroupTotal;
    }
    /**
     * Set GroupTotal value
     * @param float $groupTotal
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public function setGroupTotal($groupTotal = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($groupTotal) && strlen(substr($groupTotal, strpos($groupTotal, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($groupTotal, strpos($groupTotal, '.') + 1))), __LINE__);
        }
        $this->GroupTotal = $groupTotal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\GroupEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
