<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EInvoiceResponseType StructType
 * @subpackage Structs
 */
class EInvoiceResponseType extends AbstractStructBase
{
    /**
     * The includesLatest
     * Meta informations extracted from the WSDL
     * - documentation: Does this include latest invoice? If false, client should make a new request after this one.
     * - use: required
     * @var string
     */
    public $includesLatest;
    /**
     * The latestChange
     * Meta informations extracted from the WSDL
     * - documentation: When the last invoice in this document was last sent to ERP. If BuyInvoiceRequest had at least one status, then this date and time shows when the last invoice in this document had a status change or was sent to ERP.
     * - use: required
     * @var string
     */
    public $latestChange;
    /**
     * The E_Invoice
     * Meta informations extracted from the WSDL
     * - ref: epl:E_Invoice
     * @var \Lib\OmnivaService\StructType\E_Invoice
     */
    public $E_Invoice;
    /**
     * Constructor method for EInvoiceResponseType
     * @uses EInvoiceResponseType::setIncludesLatest()
     * @uses EInvoiceResponseType::setLatestChange()
     * @uses EInvoiceResponseType::setE_Invoice()
     * @param string $includesLatest
     * @param string $latestChange
     * @param \Lib\OmnivaService\StructType\E_Invoice $e_Invoice
     */
    public function __construct($includesLatest = null, $latestChange = null, \Lib\OmnivaService\StructType\E_Invoice $e_Invoice = null)
    {
        $this
            ->setIncludesLatest($includesLatest)
            ->setLatestChange($latestChange)
            ->setE_Invoice($e_Invoice);
    }
    /**
     * Get includesLatest value
     * @return string
     */
    public function getIncludesLatest()
    {
        return $this->includesLatest;
    }
    /**
     * Set includesLatest value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includesLatest
     * @return \Lib\OmnivaService\StructType\EInvoiceResponseType
     */
    public function setIncludesLatest($includesLatest = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($includesLatest)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $includesLatest, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->includesLatest = $includesLatest;
        return $this;
    }
    /**
     * Get latestChange value
     * @return string
     */
    public function getLatestChange()
    {
        return $this->latestChange;
    }
    /**
     * Set latestChange value
     * @param string $latestChange
     * @return \Lib\OmnivaService\StructType\EInvoiceResponseType
     */
    public function setLatestChange($latestChange = null)
    {
        // validation for constraint: string
        if (!is_null($latestChange) && !is_string($latestChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latestChange)), __LINE__);
        }
        $this->latestChange = $latestChange;
        return $this;
    }
    /**
     * Get E_Invoice value
     * @return \Lib\OmnivaService\StructType\E_Invoice|null
     */
    public function getE_Invoice()
    {
        return $this->E_Invoice;
    }
    /**
     * Set E_Invoice value
     * @param \Lib\OmnivaService\StructType\E_Invoice $e_Invoice
     * @return \Lib\OmnivaService\StructType\EInvoiceResponseType
     */
    public function setE_Invoice(\Lib\OmnivaService\StructType\E_Invoice $e_Invoice = null)
    {
        $this->E_Invoice = $e_Invoice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\EInvoiceResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
