<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EInvoiceRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: e-arvetekeskus.eu extension of Estonian electronic invoice format in order to receive pdf attachments together with Estonian e-invoice | Estonian e-invoice version 1.0. More info available at
 * http://www.pangaliit.ee/arveldused/e-arve/
 * @subpackage Structs
 */
class EInvoiceRequest extends AbstractStructBase
{
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP. | Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - use: required
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The E_Invoice
     * Meta informations extracted from the WSDL
     * - ref: epl:E_Invoice
     * @var \Lib\OmnivaService\StructType\E_Invoice
     */
    public $E_Invoice;
    /**
     * The PdfAttachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: PdfAttachment
     * @var \Lib\OmnivaService\StructType\Base64FileType[]
     */
    public $PdfAttachment;
    /**
     * The operator
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $operator;
    /**
     * Constructor method for EInvoiceRequest
     * @uses EInvoiceRequest::setAuthPhrase()
     * @uses EInvoiceRequest::setE_Invoice()
     * @uses EInvoiceRequest::setPdfAttachment()
     * @uses EInvoiceRequest::setOperator()
     * @param string $authPhrase
     * @param \Lib\OmnivaService\StructType\E_Invoice $e_Invoice
     * @param \Lib\OmnivaService\StructType\Base64FileType[] $pdfAttachment
     * @param string $operator
     */
    public function __construct($authPhrase = null, \Lib\OmnivaService\StructType\E_Invoice $e_Invoice = null, array $pdfAttachment = array(), $operator = null)
    {
        $this
            ->setAuthPhrase($authPhrase)
            ->setE_Invoice($e_Invoice)
            ->setPdfAttachment($pdfAttachment)
            ->setOperator($operator);
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\EInvoiceRequest
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get E_Invoice value
     * @return \Lib\OmnivaService\StructType\E_Invoice|null
     */
    public function getE_Invoice()
    {
        return $this->E_Invoice;
    }
    /**
     * Set E_Invoice value
     * @param \Lib\OmnivaService\StructType\E_Invoice $e_Invoice
     * @return \Lib\OmnivaService\StructType\EInvoiceRequest
     */
    public function setE_Invoice(\Lib\OmnivaService\StructType\E_Invoice $e_Invoice = null)
    {
        $this->E_Invoice = $e_Invoice;
        return $this;
    }
    /**
     * Get PdfAttachment value
     * @return \Lib\OmnivaService\StructType\Base64FileType[]|null
     */
    public function getPdfAttachment()
    {
        return $this->PdfAttachment;
    }
    /**
     * Set PdfAttachment value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\Base64FileType[] $pdfAttachment
     * @return \Lib\OmnivaService\StructType\EInvoiceRequest
     */
    public function setPdfAttachment(array $pdfAttachment = array())
    {
        foreach ($pdfAttachment as $eInvoiceRequestPdfAttachmentItem) {
            // validation for constraint: itemType
            if (!$eInvoiceRequestPdfAttachmentItem instanceof \Lib\OmnivaService\StructType\Base64FileType) {
                throw new \InvalidArgumentException(sprintf('The PdfAttachment property can only contain items of \Lib\OmnivaService\StructType\Base64FileType, "%s" given', is_object($eInvoiceRequestPdfAttachmentItem) ? get_class($eInvoiceRequestPdfAttachmentItem) : gettype($eInvoiceRequestPdfAttachmentItem)), __LINE__);
            }
        }
        $this->PdfAttachment = $pdfAttachment;
        return $this;
    }
    /**
     * Add item to PdfAttachment value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\Base64FileType $item
     * @return \Lib\OmnivaService\StructType\EInvoiceRequest
     */
    public function addToPdfAttachment(\Lib\OmnivaService\StructType\Base64FileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\Base64FileType) {
            throw new \InvalidArgumentException(sprintf('The PdfAttachment property can only contain items of \Lib\OmnivaService\StructType\Base64FileType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PdfAttachment[] = $item;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \Lib\OmnivaService\StructType\EInvoiceRequest
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operator, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\EInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
