<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostReportExportResponseType StructType
 * @subpackage Structs
 */
class CostReportExportResponseType extends AbstractStructBase
{
    /**
     * The includesLatest
     * Meta informations extracted from the WSDL
     * - documentation: Does this include latest cost reports? If false, client should make a new request after this one.
     * - use: required
     * @var string
     */
    public $includesLatest;
    /**
     * The latestChange
     * Meta informations extracted from the WSDL
     * - documentation: When the last cost report in this document was last sent to ERP. If CostReportExportRequest had at least one status, then this date and time shows when the last invoice in this document had a status change or was sent to ERP.
     * - use: required
     * @var string
     */
    public $latestChange;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for CostReportExportResponseType
     * @uses CostReportExportResponseType::setIncludesLatest()
     * @uses CostReportExportResponseType::setLatestChange()
     * @uses CostReportExportResponseType::setAny()
     * @param string $includesLatest
     * @param string $latestChange
     * @param \DOMDocument $any
     */
    public function __construct($includesLatest = null, $latestChange = null, \DOMDocument $any = null)
    {
        $this
            ->setIncludesLatest($includesLatest)
            ->setLatestChange($latestChange)
            ->setAny($any);
    }
    /**
     * Get includesLatest value
     * @return string
     */
    public function getIncludesLatest()
    {
        return $this->includesLatest;
    }
    /**
     * Set includesLatest value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includesLatest
     * @return \Lib\OmnivaService\StructType\CostReportExportResponseType
     */
    public function setIncludesLatest($includesLatest = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($includesLatest)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $includesLatest, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->includesLatest = $includesLatest;
        return $this;
    }
    /**
     * Get latestChange value
     * @return string
     */
    public function getLatestChange()
    {
        return $this->latestChange;
    }
    /**
     * Set latestChange value
     * @param string $latestChange
     * @return \Lib\OmnivaService\StructType\CostReportExportResponseType
     */
    public function setLatestChange($latestChange = null)
    {
        // validation for constraint: string
        if (!is_null($latestChange) && !is_string($latestChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latestChange)), __LINE__);
        }
        $this->latestChange = $latestChange;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Lib\OmnivaService\StructType\CostReportExportResponseType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Lib\OmnivaService\StructType\CostReportExportResponseType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\CostReportExportResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
