<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostReportAttachmentRequestType StructType
 * @subpackage Structs
 */
class CostReportAttachmentRequestType extends AbstractStructBase
{
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The Attachment
     * Meta informations extracted from the WSDL
     * - documentation: Requested attachment, fileName is filled in response
     * @var \Lib\OmnivaService\StructType\CostReportAttachmentType
     */
    public $Attachment;
    /**
     * Constructor method for CostReportAttachmentRequestType
     * @uses CostReportAttachmentRequestType::setAuthPhrase()
     * @uses CostReportAttachmentRequestType::setAttachment()
     * @param string $authPhrase
     * @param \Lib\OmnivaService\StructType\CostReportAttachmentType $attachment
     */
    public function __construct($authPhrase = null, \Lib\OmnivaService\StructType\CostReportAttachmentType $attachment = null)
    {
        $this
            ->setAuthPhrase($authPhrase)
            ->setAttachment($attachment);
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\CostReportAttachmentRequestType
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \Lib\OmnivaService\StructType\CostReportAttachmentType|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param \Lib\OmnivaService\StructType\CostReportAttachmentType $attachment
     * @return \Lib\OmnivaService\StructType\CostReportAttachmentRequestType
     */
    public function setAttachment(\Lib\OmnivaService\StructType\CostReportAttachmentType $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\CostReportAttachmentRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
