<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactDataRecord StructType
 * @subpackage Structs
 */
class ContactDataRecord extends AbstractStructBase
{
    /**
     * The ContactName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 70
     * - pattern: [ -ÿ]*
     * @var string
     */
    public $ContactName;
    /**
     * The ContactPersonCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $ContactPersonCode;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $PhoneNumber;
    /**
     * The FaxNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $FaxNumber;
    /**
     * The E_mailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: .+@.+
     * @var string
     */
    public $E_mailAddress;
    /**
     * The LegalAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\AddressRecord
     */
    public $LegalAddress;
    /**
     * The MailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\AddressRecord
     */
    public $MailAddress;
    /**
     * The ContactInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\ExtensionRecord[]
     */
    public $ContactInformation;
    /**
     * Constructor method for ContactDataRecord
     * @uses ContactDataRecord::setContactName()
     * @uses ContactDataRecord::setContactPersonCode()
     * @uses ContactDataRecord::setPhoneNumber()
     * @uses ContactDataRecord::setFaxNumber()
     * @uses ContactDataRecord::setE_mailAddress()
     * @uses ContactDataRecord::setLegalAddress()
     * @uses ContactDataRecord::setMailAddress()
     * @uses ContactDataRecord::setContactInformation()
     * @param string $contactName
     * @param string $contactPersonCode
     * @param string $phoneNumber
     * @param string $faxNumber
     * @param string $e_mailAddress
     * @param \Lib\OmnivaService\StructType\AddressRecord $legalAddress
     * @param \Lib\OmnivaService\StructType\AddressRecord $mailAddress
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $contactInformation
     */
    public function __construct($contactName = null, $contactPersonCode = null, $phoneNumber = null, $faxNumber = null, $e_mailAddress = null, \Lib\OmnivaService\StructType\AddressRecord $legalAddress = null, \Lib\OmnivaService\StructType\AddressRecord $mailAddress = null, array $contactInformation = array())
    {
        $this
            ->setContactName($contactName)
            ->setContactPersonCode($contactPersonCode)
            ->setPhoneNumber($phoneNumber)
            ->setFaxNumber($faxNumber)
            ->setE_mailAddress($e_mailAddress)
            ->setLegalAddress($legalAddress)
            ->setMailAddress($mailAddress)
            ->setContactInformation($contactInformation);
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contactName) && strlen($contactName) > 70) || (is_array($contactName) && count($contactName) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($contactName) ? strlen($contactName) : count($contactName)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($contactName) && !preg_match('/[ -ÿ]*/', $contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[ -ÿ]*", "%s" given', var_export($contactName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get ContactPersonCode value
     * @return string|null
     */
    public function getContactPersonCode()
    {
        return $this->ContactPersonCode;
    }
    /**
     * Set ContactPersonCode value
     * @param string $contactPersonCode
     * @return \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public function setContactPersonCode($contactPersonCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contactPersonCode) && strlen($contactPersonCode) > 15) || (is_array($contactPersonCode) && count($contactPersonCode) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($contactPersonCode) ? strlen($contactPersonCode) : count($contactPersonCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contactPersonCode) && !is_string($contactPersonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactPersonCode)), __LINE__);
        }
        $this->ContactPersonCode = $contactPersonCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phoneNumber) && strlen($phoneNumber) > 100) || (is_array($phoneNumber) && count($phoneNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($phoneNumber) ? strlen($phoneNumber) : count($phoneNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($faxNumber) && strlen($faxNumber) > 100) || (is_array($faxNumber) && count($faxNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($faxNumber) ? strlen($faxNumber) : count($faxNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get E_mailAddress value
     * @return string|null
     */
    public function getE_mailAddress()
    {
        return $this->{'E-mailAddress'};
    }
    /**
     * Set E_mailAddress value
     * @param string $e_mailAddress
     * @return \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public function setE_mailAddress($e_mailAddress = null)
    {
        // validation for constraint: pattern
        if (is_scalar($e_mailAddress) && !preg_match('/.+@.+/', $e_mailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches ".+@.+", "%s" given', var_export($e_mailAddress, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($e_mailAddress) && !is_string($e_mailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e_mailAddress)), __LINE__);
        }
        $this->E_mailAddress = $this->{'E-mailAddress'} = $e_mailAddress;
        return $this;
    }
    /**
     * Get LegalAddress value
     * @return \Lib\OmnivaService\StructType\AddressRecord|null
     */
    public function getLegalAddress()
    {
        return $this->LegalAddress;
    }
    /**
     * Set LegalAddress value
     * @param \Lib\OmnivaService\StructType\AddressRecord $legalAddress
     * @return \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public function setLegalAddress(\Lib\OmnivaService\StructType\AddressRecord $legalAddress = null)
    {
        $this->LegalAddress = $legalAddress;
        return $this;
    }
    /**
     * Get MailAddress value
     * @return \Lib\OmnivaService\StructType\AddressRecord|null
     */
    public function getMailAddress()
    {
        return $this->MailAddress;
    }
    /**
     * Set MailAddress value
     * @param \Lib\OmnivaService\StructType\AddressRecord $mailAddress
     * @return \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public function setMailAddress(\Lib\OmnivaService\StructType\AddressRecord $mailAddress = null)
    {
        $this->MailAddress = $mailAddress;
        return $this;
    }
    /**
     * Get ContactInformation value
     * @return \Lib\OmnivaService\StructType\ExtensionRecord[]|null
     */
    public function getContactInformation()
    {
        return $this->ContactInformation;
    }
    /**
     * Set ContactInformation value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $contactInformation
     * @return \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public function setContactInformation(array $contactInformation = array())
    {
        foreach ($contactInformation as $contactDataRecordContactInformationItem) {
            // validation for constraint: itemType
            if (!$contactDataRecordContactInformationItem instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
                throw new \InvalidArgumentException(sprintf('The ContactInformation property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($contactDataRecordContactInformationItem) ? get_class($contactDataRecordContactInformationItem) : gettype($contactDataRecordContactInformationItem)), __LINE__);
            }
        }
        $this->ContactInformation = $contactInformation;
        return $this;
    }
    /**
     * Add item to ContactInformation value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord $item
     * @return \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public function addToContactInformation(\Lib\OmnivaService\StructType\ExtensionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
            throw new \InvalidArgumentException(sprintf('The ContactInformation property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactInformation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
