<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyStatusRequestType StructType
 * @subpackage Structs
 */
class CompanyStatusRequestType extends AbstractStructBase
{
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The RegNumber
     * @var \Lib\OmnivaService\StructType\RegNumber
     */
    public $RegNumber;
    /**
     * The subset
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $subset;
    /**
     * Constructor method for CompanyStatusRequestType
     * @uses CompanyStatusRequestType::setAuthPhrase()
     * @uses CompanyStatusRequestType::setRegNumber()
     * @uses CompanyStatusRequestType::setSubset()
     * @param string $authPhrase
     * @param \Lib\OmnivaService\StructType\RegNumber $regNumber
     * @param string $subset
     */
    public function __construct($authPhrase = null, \Lib\OmnivaService\StructType\RegNumber $regNumber = null, $subset = null)
    {
        $this
            ->setAuthPhrase($authPhrase)
            ->setRegNumber($regNumber)
            ->setSubset($subset);
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\CompanyStatusRequestType
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get RegNumber value
     * @return \Lib\OmnivaService\StructType\RegNumber|null
     */
    public function getRegNumber()
    {
        return $this->RegNumber;
    }
    /**
     * Set RegNumber value
     * @param \Lib\OmnivaService\StructType\RegNumber $regNumber
     * @return \Lib\OmnivaService\StructType\CompanyStatusRequestType
     */
    public function setRegNumber(\Lib\OmnivaService\StructType\RegNumber $regNumber = null)
    {
        $this->RegNumber = $regNumber;
        return $this;
    }
    /**
     * Get subset value
     * @return string|null
     */
    public function getSubset()
    {
        return $this->subset;
    }
    /**
     * Set subset value
     * @param string $subset
     * @return \Lib\OmnivaService\StructType\CompanyStatusRequestType
     */
    public function setSubset($subset = null)
    {
        // validation for constraint: string
        if (!is_null($subset) && !is_string($subset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subset)), __LINE__);
        }
        $this->subset = $subset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\CompanyStatusRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
