<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BuyInvoiceReqType StructType
 * @subpackage Structs
 */
class BuyInvoiceReqType extends AbstractStructBase
{
    /**
     * The since
     * Meta informations extracted from the WSDL
     * - documentation: Only consider changes that have been made in EAK after this date. If at least one state is given, invoices that are sent to erp after this date or whose state has changed after this datum are returned. If no state is given, only
     * these invoices are returned that were sent to erp after this date.
     * - use: required
     * @var string
     */
    public $since;
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - documentation: If at least one state is specified then only buy infoices with this state are returned (if any).
     * @var string
     */
    public $state;
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $format;
    /**
     * The operator
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $operator;
    /**
     * Constructor method for BuyInvoiceReqType
     * @uses BuyInvoiceReqType::setSince()
     * @uses BuyInvoiceReqType::setAuthPhrase()
     * @uses BuyInvoiceReqType::setState()
     * @uses BuyInvoiceReqType::setFormat()
     * @uses BuyInvoiceReqType::setOperator()
     * @param string $since
     * @param string $authPhrase
     * @param string $state
     * @param string $format
     * @param string $operator
     */
    public function __construct($since = null, $authPhrase = null, $state = null, $format = null, $operator = null)
    {
        $this
            ->setSince($since)
            ->setAuthPhrase($authPhrase)
            ->setState($state)
            ->setFormat($format)
            ->setOperator($operator);
    }
    /**
     * Get since value
     * @return string
     */
    public function getSince()
    {
        return $this->since;
    }
    /**
     * Set since value
     * @param string $since
     * @return \Lib\OmnivaService\StructType\BuyInvoiceReqType
     */
    public function setSince($since = null)
    {
        // validation for constraint: string
        if (!is_null($since) && !is_string($since)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($since)), __LINE__);
        }
        $this->since = $since;
        return $this;
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\BuyInvoiceReqType
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \Lib\OmnivaService\EnumType\BuyInvoiceStateType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\BuyInvoiceStateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \Lib\OmnivaService\StructType\BuyInvoiceReqType
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\BuyInvoiceStateType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \Lib\OmnivaService\EnumType\BuyInvoiceStateType::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \Lib\OmnivaService\EnumType\InvoiceFormatType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\InvoiceFormatType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \Lib\OmnivaService\StructType\BuyInvoiceReqType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\InvoiceFormatType::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $format, implode(', ', \Lib\OmnivaService\EnumType\InvoiceFormatType::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \Lib\OmnivaService\StructType\BuyInvoiceReqType
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operator, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\BuyInvoiceReqType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
