<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BuyInvoiceRegisteredReqType StructType
 * @subpackage Structs
 */
class BuyInvoiceRegisteredReqType extends AbstractStructBase
{
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The RegisteredInvoice
     * Meta informations extracted from the WSDL
     * - documentation: If at least one state is specified then only buy infoices with this state are returned (if any).
     * @var \Lib\OmnivaService\StructType\RegisteredInvoiceType
     */
    public $RegisteredInvoice;
    /**
     * Constructor method for BuyInvoiceRegisteredReqType
     * @uses BuyInvoiceRegisteredReqType::setAuthPhrase()
     * @uses BuyInvoiceRegisteredReqType::setRegisteredInvoice()
     * @param string $authPhrase
     * @param \Lib\OmnivaService\StructType\RegisteredInvoiceType $registeredInvoice
     */
    public function __construct($authPhrase = null, \Lib\OmnivaService\StructType\RegisteredInvoiceType $registeredInvoice = null)
    {
        $this
            ->setAuthPhrase($authPhrase)
            ->setRegisteredInvoice($registeredInvoice);
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\BuyInvoiceRegisteredReqType
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get RegisteredInvoice value
     * @return \Lib\OmnivaService\StructType\RegisteredInvoiceType|null
     */
    public function getRegisteredInvoice()
    {
        return $this->RegisteredInvoice;
    }
    /**
     * Set RegisteredInvoice value
     * @param \Lib\OmnivaService\StructType\RegisteredInvoiceType $registeredInvoice
     * @return \Lib\OmnivaService\StructType\BuyInvoiceRegisteredReqType
     */
    public function setRegisteredInvoice(\Lib\OmnivaService\StructType\RegisteredInvoiceType $registeredInvoice = null)
    {
        $this->RegisteredInvoice = $registeredInvoice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\BuyInvoiceRegisteredReqType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
