<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Base64FileType StructType
 * @subpackage Structs
 */
class Base64FileType extends AbstractStructBase
{
    /**
     * The invoiceId
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 100
     * @var string
     */
    public $invoiceId;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * Constructor method for Base64FileType
     * @uses Base64FileType::setInvoiceId()
     * @uses Base64FileType::set_()
     * @param string $invoiceId
     * @param string $_
     */
    public function __construct($invoiceId = null, $_ = null)
    {
        $this
            ->setInvoiceId($invoiceId)
            ->set_($_);
    }
    /**
     * Get invoiceId value
     * @return string
     */
    public function getInvoiceId()
    {
        return $this->invoiceId;
    }
    /**
     * Set invoiceId value
     * @param string $invoiceId
     * @return \Lib\OmnivaService\StructType\Base64FileType
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceId) && strlen($invoiceId) > 100) || (is_array($invoiceId) && count($invoiceId) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($invoiceId) ? strlen($invoiceId) : count($invoiceId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceId)), __LINE__);
        }
        $this->invoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Lib\OmnivaService\StructType\Base64FileType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\Base64FileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
