<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticatedRequest StructType
 * @subpackage Structs
 */
abstract class AuthenticatedRequest extends AbstractStructBase
{
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * Constructor method for AuthenticatedRequest
     * @uses AuthenticatedRequest::setAuthPhrase()
     * @param string $authPhrase
     */
    public function __construct($authPhrase = null)
    {
        $this
            ->setAuthPhrase($authPhrase);
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\AuthenticatedRequest
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\AuthenticatedRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
