<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressRecord StructType
 * @subpackage Structs
 */
class AddressRecord extends AbstractStructBase
{
    /**
     * The PostalAddress1
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $PostalAddress1;
    /**
     * The PostalAddress2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $PostalAddress2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $City;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $PostalCode;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $Country;
    /**
     * The Extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\ExtensionRecord[]
     */
    public $Extension;
    /**
     * Constructor method for AddressRecord
     * @uses AddressRecord::setPostalAddress1()
     * @uses AddressRecord::setPostalAddress2()
     * @uses AddressRecord::setCity()
     * @uses AddressRecord::setPostalCode()
     * @uses AddressRecord::setCountry()
     * @uses AddressRecord::setExtension()
     * @param string $postalAddress1
     * @param string $postalAddress2
     * @param string $city
     * @param string $postalCode
     * @param string $country
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $extension
     */
    public function __construct($postalAddress1 = null, $postalAddress2 = null, $city = null, $postalCode = null, $country = null, array $extension = array())
    {
        $this
            ->setPostalAddress1($postalAddress1)
            ->setPostalAddress2($postalAddress2)
            ->setCity($city)
            ->setPostalCode($postalCode)
            ->setCountry($country)
            ->setExtension($extension);
    }
    /**
     * Get PostalAddress1 value
     * @return string|null
     */
    public function getPostalAddress1()
    {
        return $this->PostalAddress1;
    }
    /**
     * Set PostalAddress1 value
     * @param string $postalAddress1
     * @return \Lib\OmnivaService\StructType\AddressRecord
     */
    public function setPostalAddress1($postalAddress1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postalAddress1) && strlen($postalAddress1) > 100) || (is_array($postalAddress1) && count($postalAddress1) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($postalAddress1) ? strlen($postalAddress1) : count($postalAddress1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postalAddress1) && !is_string($postalAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalAddress1)), __LINE__);
        }
        $this->PostalAddress1 = $postalAddress1;
        return $this;
    }
    /**
     * Get PostalAddress2 value
     * @return string|null
     */
    public function getPostalAddress2()
    {
        return $this->PostalAddress2;
    }
    /**
     * Set PostalAddress2 value
     * @param string $postalAddress2
     * @return \Lib\OmnivaService\StructType\AddressRecord
     */
    public function setPostalAddress2($postalAddress2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postalAddress2) && strlen($postalAddress2) > 100) || (is_array($postalAddress2) && count($postalAddress2) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($postalAddress2) ? strlen($postalAddress2) : count($postalAddress2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postalAddress2) && !is_string($postalAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalAddress2)), __LINE__);
        }
        $this->PostalAddress2 = $postalAddress2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Lib\OmnivaService\StructType\AddressRecord
     */
    public function setCity($city = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($city) && strlen($city) > 100) || (is_array($city) && count($city) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($city) ? strlen($city) : count($city)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \Lib\OmnivaService\StructType\AddressRecord
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postalCode) && strlen($postalCode) > 10) || (is_array($postalCode) && count($postalCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($postalCode) ? strlen($postalCode) : count($postalCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \Lib\OmnivaService\StructType\AddressRecord
     */
    public function setCountry($country = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($country) && strlen($country) > 100) || (is_array($country) && count($country) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($country) ? strlen($country) : count($country)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Extension value
     * @return \Lib\OmnivaService\StructType\ExtensionRecord[]|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $extension
     * @return \Lib\OmnivaService\StructType\AddressRecord
     */
    public function setExtension(array $extension = array())
    {
        foreach ($extension as $addressRecordExtensionItem) {
            // validation for constraint: itemType
            if (!$addressRecordExtensionItem instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
                throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($addressRecordExtensionItem) ? get_class($addressRecordExtensionItem) : gettype($addressRecordExtensionItem)), __LINE__);
            }
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Add item to Extension value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord $item
     * @return \Lib\OmnivaService\StructType\AddressRecord
     */
    public function addToExtension(\Lib\OmnivaService\StructType\ExtensionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
            throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Extension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\AddressRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
