<?php

namespace Lib\OmnivaService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for EI ServiceType
 * @subpackage Services
 */
class EI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\EInvoiceRequest $eInvoiceRequest
     * @return \Lib\OmnivaService\StructType\SimpleResponseType|bool
     */
    public function EInvoice(\Lib\OmnivaService\StructType\EInvoiceRequest $eInvoiceRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->EInvoice($eInvoiceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Lib\OmnivaService\StructType\SimpleResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
