<?php

namespace Lib\OmnivaService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dimension ServiceType
 * @subpackage Services
 */
class Dimension extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DimensionRegistry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\DimensionRegistryRequestType $dimensionRegistryRequest
     * @return \Lib\OmnivaService\StructType\DimensionRegistryResponse|bool
     */
    public function DimensionRegistry(\Lib\OmnivaService\StructType\DimensionRegistryRequestType $dimensionRegistryRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->DimensionRegistry($dimensionRegistryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Lib\OmnivaService\StructType\DimensionRegistryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
