<?php

namespace Lib\OmnivaService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Company ServiceType
 * @subpackage Services
 */
class Company extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CompanyStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\CompanyStatusRequestType $companyStatusRequest
     * @return \Lib\OmnivaService\StructType\CompanyStatusResponseType|bool
     */
    public function CompanyStatus(\Lib\OmnivaService\StructType\CompanyStatusRequestType $companyStatusRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CompanyStatus($companyStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Lib\OmnivaService\StructType\CompanyStatusResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
