<?php

namespace Lib\OmnivaService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Buy ServiceType
 * @subpackage Services
 */
class Buy extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BuyInvoiceExport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\BuyInvoiceReqType $buyInvoiceExportRequest
     * @return \Lib\OmnivaService\StructType\EInvoiceResponseType|bool
     */
    public function BuyInvoiceExport(\Lib\OmnivaService\StructType\BuyInvoiceReqType $buyInvoiceExportRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->BuyInvoiceExport($buyInvoiceExportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BuyInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \Lib\OmnivaService\StructType\EInvoiceRespoonseType|bool
     */
    public function BuyInvoices()
    {
        try {
            $this->setResult(self::getSoapClient()->BuyInvoices());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BuyInvoicePdf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\BuyInvoicePdfRequest $buyInvoicePdfRequest
     * @return \Lib\OmnivaService\StructType\BuyInvoicePdfResponse|bool
     */
    public function BuyInvoicePdf(\Lib\OmnivaService\StructType\BuyInvoicePdfRequest $buyInvoicePdfRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->BuyInvoicePdf($buyInvoicePdfRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BuyInvoiceRegistered
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\BuyInvoiceRegisteredReqType $buyInvoiceRegisteredRequest
     * @return \Lib\OmnivaService\StructType\SimpleResponseType|bool
     */
    public function BuyInvoiceRegistered(\Lib\OmnivaService\StructType\BuyInvoiceRegisteredReqType $buyInvoiceRegisteredRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->BuyInvoiceRegistered($buyInvoiceRegisteredRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BuyInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\BuyInvoiceReqType $buyInvoiceRequest
     * @return void|bool
     */
    public function BuyInvoice(\Lib\OmnivaService\StructType\BuyInvoiceReqType $buyInvoiceRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->BuyInvoice($buyInvoiceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void|\Lib\OmnivaService\StructType\BuyInvoicePdfResponse|\Lib\OmnivaService\StructType\EInvoiceResponseType|\Lib\OmnivaService\StructType\EInvoiceRespoonseType|\Lib\OmnivaService\StructType\SimpleResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
