<?php

namespace Lib\OmnivaService\EnumType;

/**
 * This class stands for YesNoType EnumType
 * Meta informations extracted from the WSDL
 * - pattern: NO
 * @subpackage Enumerations
 */
class YesNoType
{
    /**
     * Constant for value 'YES'
     * @return string 'YES'
     */
    const VALUE_YES = 'YES';
    /**
     * Constant for value 'NO'
     * @return string 'NO'
     */
    const VALUE_NO = 'NO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_YES
     * @uses self::VALUE_NO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_YES,
            self::VALUE_NO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
