<?php

namespace Lib\OmnivaService\EnumType;

/**
 * This class stands for SaleInvoiceStateType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Types of sale invoices that can be obtained from EAK
 * @subpackage Enumerations
 */
class SaleInvoiceStateType
{
    /**
     * Constant for value 'CREATED'
     * @return string 'CREATED'
     */
    const VALUE_CREATED = 'CREATED';
    /**
     * Constant for value 'IMPORTED'
     * @return string 'IMPORTED'
     */
    const VALUE_IMPORTED = 'IMPORTED';
    /**
     * Constant for value 'SENT'
     * @return string 'SENT'
     */
    const VALUE_SENT = 'SENT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CREATED
     * @uses self::VALUE_IMPORTED
     * @uses self::VALUE_SENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREATED,
            self::VALUE_IMPORTED,
            self::VALUE_SENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
