<?php

namespace Lib\OmnivaService\EnumType;

/**
 * This class stands for InvoiceFormatType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Types of formats supported by invoice export
 * @subpackage Enumerations
 */
class InvoiceFormatType
{
    /**
     * Constant for value 'AXAPTA'
     * @return string 'AXAPTA'
     */
    const VALUE_AXAPTA = 'AXAPTA';
    /**
     * Constant for value 'E_INV_1_1'
     * @return string 'E_INV_1_1'
     */
    const VALUE_E_INV_1_1 = 'E_INV_1_1';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AXAPTA
     * @uses self::VALUE_E_INV_1_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AXAPTA,
            self::VALUE_E_INV_1_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
