<?php

namespace Lib\OmnivaService\EnumType;

/**
 * This class stands for CostReportStateType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Types of cost reports that can be obtained from EAK
 * @subpackage Enumerations
 */
class CostReportStateType
{
    /**
     * Constant for value 'COST_REPORT_STATE_CREATED'
     * @return string 'COST_REPORT_STATE_CREATED'
     */
    const VALUE_COST_REPORT_STATE_CREATED = 'COST_REPORT_STATE_CREATED';
    /**
     * Constant for value 'COST_REPORT_STATE_BEING_VERIFIED'
     * @return string 'COST_REPORT_STATE_BEING_VERIFIED'
     */
    const VALUE_COST_REPORT_STATE_BEING_VERIFIED = 'COST_REPORT_STATE_BEING_VERIFIED';
    /**
     * Constant for value 'COST_REPORT_STATE_VERIFIED'
     * @return string 'COST_REPORT_STATE_VERIFIED'
     */
    const VALUE_COST_REPORT_STATE_VERIFIED = 'COST_REPORT_STATE_VERIFIED';
    /**
     * Constant for value 'COST_REPORT_STATE_DECLINED'
     * @return string 'COST_REPORT_STATE_DECLINED'
     */
    const VALUE_COST_REPORT_STATE_DECLINED = 'COST_REPORT_STATE_DECLINED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COST_REPORT_STATE_CREATED
     * @uses self::VALUE_COST_REPORT_STATE_BEING_VERIFIED
     * @uses self::VALUE_COST_REPORT_STATE_VERIFIED
     * @uses self::VALUE_COST_REPORT_STATE_DECLINED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COST_REPORT_STATE_CREATED,
            self::VALUE_COST_REPORT_STATE_BEING_VERIFIED,
            self::VALUE_COST_REPORT_STATE_VERIFIED,
            self::VALUE_COST_REPORT_STATE_DECLINED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
