<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomLocationPrefType StructType
 * @subpackage Structs
 */
class RoomLocationPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The RoomLocationType
     * @var string
     */
    public $RoomLocationType;
    /**
     * Constructor method for RoomLocationPrefType
     * @uses RoomLocationPrefType::set_()
     * @uses RoomLocationPrefType::setPreferLevel()
     * @uses RoomLocationPrefType::setRoomLocationType()
     * @param string $_
     * @param string $preferLevel
     * @param string $roomLocationType
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $roomLocationType = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setRoomLocationType($roomLocationType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \rdyescapia\StructType\RoomLocationPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapia\StructType\RoomLocationPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get RoomLocationType value
     * @return string|null
     */
    public function getRoomLocationType()
    {
        return $this->RoomLocationType;
    }
    /**
     * Set RoomLocationType value
     * @param string $roomLocationType
     * @return \rdyescapia\StructType\RoomLocationPrefType
     */
    public function setRoomLocationType($roomLocationType = null)
    {
        // validation for constraint: string
        if (!is_null($roomLocationType) && !is_string($roomLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomLocationType, true), gettype($roomLocationType)), __LINE__);
        }
        $this->RoomLocationType = $roomLocationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\RoomLocationPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
