<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Radius StructType
 * @subpackage Structs
 */
class Radius extends AbstractStructBase
{
    /**
     * The Distance
     * @var string
     */
    public $Distance;
    /**
     * The DistanceMeasure
     * @var string
     */
    public $DistanceMeasure;
    /**
     * The Direction
     * @var string
     */
    public $Direction;
    /**
     * The DistanceMax
     * @var string
     */
    public $DistanceMax;
    /**
     * Constructor method for Radius
     * @uses Radius::setDistance()
     * @uses Radius::setDistanceMeasure()
     * @uses Radius::setDirection()
     * @uses Radius::setDistanceMax()
     * @param string $distance
     * @param string $distanceMeasure
     * @param string $direction
     * @param string $distanceMax
     */
    public function __construct($distance = null, $distanceMeasure = null, $direction = null, $distanceMax = null)
    {
        $this
            ->setDistance($distance)
            ->setDistanceMeasure($distanceMeasure)
            ->setDirection($direction)
            ->setDistanceMax($distanceMax);
    }
    /**
     * Get Distance value
     * @return string|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param string $distance
     * @return \rdyescapia\StructType\Radius
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: string
        if (!is_null($distance) && !is_string($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get DistanceMeasure value
     * @return string|null
     */
    public function getDistanceMeasure()
    {
        return $this->DistanceMeasure;
    }
    /**
     * Set DistanceMeasure value
     * @param string $distanceMeasure
     * @return \rdyescapia\StructType\Radius
     */
    public function setDistanceMeasure($distanceMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($distanceMeasure) && !is_string($distanceMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceMeasure, true), gettype($distanceMeasure)), __LINE__);
        }
        $this->DistanceMeasure = $distanceMeasure;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \rdyescapia\StructType\Radius
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get DistanceMax value
     * @return string|null
     */
    public function getDistanceMax()
    {
        return $this->DistanceMax;
    }
    /**
     * Set DistanceMax value
     * @param string $distanceMax
     * @return \rdyescapia\StructType\Radius
     */
    public function setDistanceMax($distanceMax = null)
    {
        // validation for constraint: string
        if (!is_null($distanceMax) && !is_string($distanceMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceMax, true), gettype($distanceMax)), __LINE__);
        }
        $this->DistanceMax = $distanceMax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\Radius
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
