<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position StructType
 * @subpackage Structs
 */
class Position extends AbstractStructBase
{
    /**
     * The Latitude
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * @var string
     */
    public $Longitude;
    /**
     * The Altitude
     * @var string
     */
    public $Altitude;
    /**
     * The AltitudeUnitOfMeasureCode
     * @var string
     */
    public $AltitudeUnitOfMeasureCode;
    /**
     * Constructor method for Position
     * @uses Position::setLatitude()
     * @uses Position::setLongitude()
     * @uses Position::setAltitude()
     * @uses Position::setAltitudeUnitOfMeasureCode()
     * @param string $latitude
     * @param string $longitude
     * @param string $altitude
     * @param string $altitudeUnitOfMeasureCode
     */
    public function __construct($latitude = null, $longitude = null, $altitude = null, $altitudeUnitOfMeasureCode = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setAltitude($altitude)
            ->setAltitudeUnitOfMeasureCode($altitudeUnitOfMeasureCode);
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \rdyescapia\StructType\Position
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \rdyescapia\StructType\Position
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Altitude value
     * @return string|null
     */
    public function getAltitude()
    {
        return $this->Altitude;
    }
    /**
     * Set Altitude value
     * @param string $altitude
     * @return \rdyescapia\StructType\Position
     */
    public function setAltitude($altitude = null)
    {
        // validation for constraint: string
        if (!is_null($altitude) && !is_string($altitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altitude, true), gettype($altitude)), __LINE__);
        }
        $this->Altitude = $altitude;
        return $this;
    }
    /**
     * Get AltitudeUnitOfMeasureCode value
     * @return string|null
     */
    public function getAltitudeUnitOfMeasureCode()
    {
        return $this->AltitudeUnitOfMeasureCode;
    }
    /**
     * Set AltitudeUnitOfMeasureCode value
     * @param string $altitudeUnitOfMeasureCode
     * @return \rdyescapia\StructType\Position
     */
    public function setAltitudeUnitOfMeasureCode($altitudeUnitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($altitudeUnitOfMeasureCode) && !is_string($altitudeUnitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altitudeUnitOfMeasureCode, true), gettype($altitudeUnitOfMeasureCode)), __LINE__);
        }
        $this->AltitudeUnitOfMeasureCode = $altitudeUnitOfMeasureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\Position
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
