<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonNameType StructType
 * @subpackage Structs
 */
class PersonNameType extends AbstractStructBase
{
    /**
     * The NamePrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NamePrefix;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $GivenName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $MiddleName;
    /**
     * The SurnamePrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurnamePrefix;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The NameSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NameSuffix;
    /**
     * The NameTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NameTitle;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The NameType
     * @var string
     */
    public $NameType;
    /**
     * Constructor method for PersonNameType
     * @uses PersonNameType::setNamePrefix()
     * @uses PersonNameType::setGivenName()
     * @uses PersonNameType::setMiddleName()
     * @uses PersonNameType::setSurnamePrefix()
     * @uses PersonNameType::setSurname()
     * @uses PersonNameType::setNameSuffix()
     * @uses PersonNameType::setNameTitle()
     * @uses PersonNameType::setShareSynchInd()
     * @uses PersonNameType::setShareMarketInd()
     * @uses PersonNameType::setNameType()
     * @param string[] $namePrefix
     * @param string[] $givenName
     * @param string[] $middleName
     * @param string $surnamePrefix
     * @param string $surname
     * @param string[] $nameSuffix
     * @param string[] $nameTitle
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $nameType
     */
    public function __construct(array $namePrefix = array(), array $givenName = array(), array $middleName = array(), $surnamePrefix = null, $surname = null, array $nameSuffix = array(), array $nameTitle = array(), $shareSynchInd = null, $shareMarketInd = null, $nameType = null)
    {
        $this
            ->setNamePrefix($namePrefix)
            ->setGivenName($givenName)
            ->setMiddleName($middleName)
            ->setSurnamePrefix($surnamePrefix)
            ->setSurname($surname)
            ->setNameSuffix($nameSuffix)
            ->setNameTitle($nameTitle)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setNameType($nameType);
    }
    /**
     * Get NamePrefix value
     * @return string[]|null
     */
    public function getNamePrefix()
    {
        return $this->NamePrefix;
    }
    /**
     * This method is responsible for validating the values passed to the setNamePrefix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNamePrefix method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNamePrefixForArrayConstraintsFromSetNamePrefix(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNamePrefixItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeNamePrefixItem)) {
                $invalidValues[] = is_object($personNameTypeNamePrefixItem) ? get_class($personNameTypeNamePrefixItem) : sprintf('%s(%s)', gettype($personNameTypeNamePrefixItem), var_export($personNameTypeNamePrefixItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NamePrefix property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NamePrefix value
     * @throws \InvalidArgumentException
     * @param string[] $namePrefix
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setNamePrefix(array $namePrefix = array())
    {
        // validation for constraint: array
        if ('' !== ($namePrefixArrayErrorMessage = self::validateNamePrefixForArrayConstraintsFromSetNamePrefix($namePrefix))) {
            throw new \InvalidArgumentException($namePrefixArrayErrorMessage, __LINE__);
        }
        $this->NamePrefix = $namePrefix;
        return $this;
    }
    /**
     * Add item to NamePrefix value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function addToNamePrefix($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NamePrefix property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NamePrefix[] = $item;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string[]|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * This method is responsible for validating the values passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForArrayConstraintsFromSetGivenName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeGivenNameItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeGivenNameItem)) {
                $invalidValues[] = is_object($personNameTypeGivenNameItem) ? get_class($personNameTypeGivenNameItem) : sprintf('%s(%s)', gettype($personNameTypeGivenNameItem), var_export($personNameTypeGivenNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GivenName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GivenName value
     * @throws \InvalidArgumentException
     * @param string[] $givenName
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setGivenName(array $givenName = array())
    {
        // validation for constraint: array
        if ('' !== ($givenNameArrayErrorMessage = self::validateGivenNameForArrayConstraintsFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameArrayErrorMessage, __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Add item to GivenName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function addToGivenName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The GivenName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GivenName[] = $item;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string[]|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * This method is responsible for validating the values passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForArrayConstraintsFromSetMiddleName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeMiddleNameItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeMiddleNameItem)) {
                $invalidValues[] = is_object($personNameTypeMiddleNameItem) ? get_class($personNameTypeMiddleNameItem) : sprintf('%s(%s)', gettype($personNameTypeMiddleNameItem), var_export($personNameTypeMiddleNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MiddleName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MiddleName value
     * @throws \InvalidArgumentException
     * @param string[] $middleName
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setMiddleName(array $middleName = array())
    {
        // validation for constraint: array
        if ('' !== ($middleNameArrayErrorMessage = self::validateMiddleNameForArrayConstraintsFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameArrayErrorMessage, __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Add item to MiddleName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function addToMiddleName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MiddleName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MiddleName[] = $item;
        return $this;
    }
    /**
     * Get SurnamePrefix value
     * @return string|null
     */
    public function getSurnamePrefix()
    {
        return $this->SurnamePrefix;
    }
    /**
     * Set SurnamePrefix value
     * @param string $surnamePrefix
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setSurnamePrefix($surnamePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($surnamePrefix) && !is_string($surnamePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surnamePrefix, true), gettype($surnamePrefix)), __LINE__);
        }
        $this->SurnamePrefix = $surnamePrefix;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return string[]|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * This method is responsible for validating the values passed to the setNameSuffix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameSuffix method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameSuffixForArrayConstraintsFromSetNameSuffix(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNameSuffixItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeNameSuffixItem)) {
                $invalidValues[] = is_object($personNameTypeNameSuffixItem) ? get_class($personNameTypeNameSuffixItem) : sprintf('%s(%s)', gettype($personNameTypeNameSuffixItem), var_export($personNameTypeNameSuffixItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameSuffix property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameSuffix value
     * @throws \InvalidArgumentException
     * @param string[] $nameSuffix
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setNameSuffix(array $nameSuffix = array())
    {
        // validation for constraint: array
        if ('' !== ($nameSuffixArrayErrorMessage = self::validateNameSuffixForArrayConstraintsFromSetNameSuffix($nameSuffix))) {
            throw new \InvalidArgumentException($nameSuffixArrayErrorMessage, __LINE__);
        }
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Add item to NameSuffix value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function addToNameSuffix($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NameSuffix property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NameSuffix[] = $item;
        return $this;
    }
    /**
     * Get NameTitle value
     * @return string[]|null
     */
    public function getNameTitle()
    {
        return $this->NameTitle;
    }
    /**
     * This method is responsible for validating the values passed to the setNameTitle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameTitle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameTitleForArrayConstraintsFromSetNameTitle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNameTitleItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeNameTitleItem)) {
                $invalidValues[] = is_object($personNameTypeNameTitleItem) ? get_class($personNameTypeNameTitleItem) : sprintf('%s(%s)', gettype($personNameTypeNameTitleItem), var_export($personNameTypeNameTitleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameTitle property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameTitle value
     * @throws \InvalidArgumentException
     * @param string[] $nameTitle
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setNameTitle(array $nameTitle = array())
    {
        // validation for constraint: array
        if ('' !== ($nameTitleArrayErrorMessage = self::validateNameTitleForArrayConstraintsFromSetNameTitle($nameTitle))) {
            throw new \InvalidArgumentException($nameTitleArrayErrorMessage, __LINE__);
        }
        $this->NameTitle = $nameTitle;
        return $this;
    }
    /**
     * Add item to NameTitle value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function addToNameTitle($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NameTitle property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NameTitle[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get NameType value
     * @return string|null
     */
    public function getNameType()
    {
        return $this->NameType;
    }
    /**
     * Set NameType value
     * @param string $nameType
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setNameType($nameType = null)
    {
        // validation for constraint: string
        if (!is_null($nameType) && !is_string($nameType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameType, true), gettype($nameType)), __LINE__);
        }
        $this->NameType = $nameType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\PersonNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
