<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParagraphType StructType
 * @subpackage Structs
 */
class ParagraphType extends AbstractStructBase
{
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - choice: Image | ListItem | Text | URL
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Image;
    /**
     * The ListItem
     * Meta information extracted from the WSDL
     * - choice: Image | ListItem | Text | URL
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ListItem
     */
    public $ListItem;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - choice: Image | ListItem | Text | URL
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\FormattedTextTextType
     */
    public $Text;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - choice: Image | ListItem | Text | URL
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The ParagraphNumber
     * @var int
     */
    public $ParagraphNumber;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * @var string
     */
    public $LastModifierID;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for ParagraphType
     * @uses ParagraphType::setImage()
     * @uses ParagraphType::setListItem()
     * @uses ParagraphType::setText()
     * @uses ParagraphType::setURL()
     * @uses ParagraphType::setName()
     * @uses ParagraphType::setParagraphNumber()
     * @uses ParagraphType::setCreateDateTime()
     * @uses ParagraphType::setCreatorID()
     * @uses ParagraphType::setLastModifyDateTime()
     * @uses ParagraphType::setLastModifierID()
     * @uses ParagraphType::setLanguage()
     * @param string $image
     * @param \rdyescapia\StructType\ListItem $listItem
     * @param \rdyescapia\StructType\FormattedTextTextType $text
     * @param string $uRL
     * @param string $name
     * @param int $paragraphNumber
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $language
     */
    public function __construct($image = null, \rdyescapia\StructType\ListItem $listItem = null, \rdyescapia\StructType\FormattedTextTextType $text = null, $uRL = null, $name = null, $paragraphNumber = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $language = null)
    {
        $this
            ->setImage($image)
            ->setListItem($listItem)
            ->setText($text)
            ->setURL($uRL)
            ->setName($name)
            ->setParagraphNumber($paragraphNumber)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setLanguage($language);
    }
    /**
     * Get Image value
     * @return string|null
     */
    public function getImage()
    {
        return isset($this->Image) ? $this->Image : null;
    }
    /**
     * This method is responsible for validating the value passed to the setImage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImage method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateImageForChoiceConstraintsFromSetImage($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ListItem',
            'Text',
            'URL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Image can\'t be set as the property %s is already set. Only one property must be set among these properties: Image, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Image value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $image
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        // validation for constraint: choice(Image, ListItem, Text, URL)
        if ('' !== ($imageChoiceErrorMessage = self::validateImageForChoiceConstraintsFromSetImage($image))) {
            throw new \InvalidArgumentException($imageChoiceErrorMessage, __LINE__);
        }
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->Image);
        } else {
            $this->Image = $image;
        }
        return $this;
    }
    /**
     * Get ListItem value
     * @return \rdyescapia\StructType\ListItem|null
     */
    public function getListItem()
    {
        return isset($this->ListItem) ? $this->ListItem : null;
    }
    /**
     * This method is responsible for validating the value passed to the setListItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListItem method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateListItemForChoiceConstraintsFromSetListItem($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Image',
            'Text',
            'URL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ListItem can\'t be set as the property %s is already set. Only one property must be set among these properties: ListItem, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ListItem value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ListItem $listItem
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setListItem(\rdyescapia\StructType\ListItem $listItem = null)
    {
        // validation for constraint: choice(Image, ListItem, Text, URL)
        if ('' !== ($listItemChoiceErrorMessage = self::validateListItemForChoiceConstraintsFromSetListItem($listItem))) {
            throw new \InvalidArgumentException($listItemChoiceErrorMessage, __LINE__);
        }
        if (is_null($listItem) || (is_array($listItem) && empty($listItem))) {
            unset($this->ListItem);
        } else {
            $this->ListItem = $listItem;
        }
        return $this;
    }
    /**
     * Get Text value
     * @return \rdyescapia\StructType\FormattedTextTextType|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * This method is responsible for validating the value passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTextForChoiceConstraintsFromSetText($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Image',
            'ListItem',
            'URL',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Text can\'t be set as the property %s is already set. Only one property must be set among these properties: Text, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Text value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FormattedTextTextType $text
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setText(\rdyescapia\StructType\FormattedTextTextType $text = null)
    {
        // validation for constraint: choice(Image, ListItem, Text, URL)
        if ('' !== ($textChoiceErrorMessage = self::validateTextForChoiceConstraintsFromSetText($text))) {
            throw new \InvalidArgumentException($textChoiceErrorMessage, __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return isset($this->URL) ? $this->URL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateURLForChoiceConstraintsFromSetURL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Image',
            'ListItem',
            'Text',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property URL can\'t be set as the property %s is already set. Only one property must be set among these properties: URL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set URL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uRL
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        // validation for constraint: choice(Image, ListItem, Text, URL)
        if ('' !== ($uRLChoiceErrorMessage = self::validateURLForChoiceConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLChoiceErrorMessage, __LINE__);
        }
        if (is_null($uRL) || (is_array($uRL) && empty($uRL))) {
            unset($this->URL);
        } else {
            $this->URL = $uRL;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ParagraphNumber value
     * @return int|null
     */
    public function getParagraphNumber()
    {
        return $this->ParagraphNumber;
    }
    /**
     * Set ParagraphNumber value
     * @param int $paragraphNumber
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setParagraphNumber($paragraphNumber = null)
    {
        // validation for constraint: int
        if (!is_null($paragraphNumber) && !(is_int($paragraphNumber) || ctype_digit($paragraphNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paragraphNumber, true), gettype($paragraphNumber)), __LINE__);
        }
        $this->ParagraphNumber = $paragraphNumber;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorID, true), gettype($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifyDateTime, true), gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifierID, true), gettype($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \rdyescapia\StructType\ParagraphType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\ParagraphType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
