<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageItemsType StructType
 * @subpackage Structs
 */
class ImageItemsType extends AbstractStructBase
{
    /**
     * The ImageItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ImageItem[]
     */
    public $ImageItem;
    /**
     * The MoreData
     * @var bool
     */
    public $MoreData;
    /**
     * Constructor method for ImageItemsType
     * @uses ImageItemsType::setImageItem()
     * @uses ImageItemsType::setMoreData()
     * @param \rdyescapia\StructType\ImageItem[] $imageItem
     * @param bool $moreData
     */
    public function __construct(array $imageItem = array(), $moreData = null)
    {
        $this
            ->setImageItem($imageItem)
            ->setMoreData($moreData);
    }
    /**
     * Get ImageItem value
     * @return \rdyescapia\StructType\ImageItem[]|null
     */
    public function getImageItem()
    {
        return $this->ImageItem;
    }
    /**
     * This method is responsible for validating the values passed to the setImageItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageItemForArrayConstraintsFromSetImageItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $imageItemsTypeImageItemItem) {
            // validation for constraint: itemType
            if (!$imageItemsTypeImageItemItem instanceof \rdyescapia\StructType\ImageItem) {
                $invalidValues[] = is_object($imageItemsTypeImageItemItem) ? get_class($imageItemsTypeImageItemItem) : sprintf('%s(%s)', gettype($imageItemsTypeImageItemItem), var_export($imageItemsTypeImageItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImageItem property can only contain items of type \rdyescapia\StructType\ImageItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImageItem value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ImageItem[] $imageItem
     * @return \rdyescapia\StructType\ImageItemsType
     */
    public function setImageItem(array $imageItem = array())
    {
        // validation for constraint: array
        if ('' !== ($imageItemArrayErrorMessage = self::validateImageItemForArrayConstraintsFromSetImageItem($imageItem))) {
            throw new \InvalidArgumentException($imageItemArrayErrorMessage, __LINE__);
        }
        $this->ImageItem = $imageItem;
        return $this;
    }
    /**
     * Add item to ImageItem value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ImageItem $item
     * @return \rdyescapia\StructType\ImageItemsType
     */
    public function addToImageItem(\rdyescapia\StructType\ImageItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\ImageItem) {
            throw new \InvalidArgumentException(sprintf('The ImageItem property can only contain items of type \rdyescapia\StructType\ImageItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImageItem[] = $item;
        return $this;
    }
    /**
     * Get MoreData value
     * @return bool|null
     */
    public function getMoreData()
    {
        return $this->MoreData;
    }
    /**
     * Set MoreData value
     * @param bool $moreData
     * @return \rdyescapia\StructType\ImageItemsType
     */
    public function setMoreData($moreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreData) && !is_bool($moreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moreData, true), gettype($moreData)), __LINE__);
        }
        $this->MoreData = $moreData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\ImageItemsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
