<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitDescriptiveInfoRequestType StructType
 * @subpackage Structs
 */
class UnitDescriptiveInfoRequestType extends AbstractStructBase
{
    /**
     * The UnitInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitInfo
     */
    public $UnitInfo;
    /**
     * The Policies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Policies
     */
    public $Policies;
    /**
     * The UnitReviews
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitReviews
     */
    public $UnitReviews;
    /**
     * The Promotions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Promotions
     */
    public $Promotions;
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The UnitCode
     * @var string
     */
    public $UnitCode;
    /**
     * The UnitName
     * @var string
     */
    public $UnitName;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The InternalUnitCode
     * @var string
     */
    public $InternalUnitCode;
    /**
     * The UnitHeadline
     * @var string
     */
    public $UnitHeadline;
    /**
     * The PropertyURL
     * @var string
     */
    public $PropertyURL;
    /**
     * The StateCodeList
     * @var string[]
     */
    public $StateCodeList;
    /**
     * The CountryCodeList
     * @var string[]
     */
    public $CountryCodeList;
    /**
     * The BrandCodeList
     * @var string[]
     */
    public $BrandCodeList;
    /**
     * The MoreDataEchoToken
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * The UpdatedAfter
     * @var string
     */
    public $UpdatedAfter;
    /**
     * Constructor method for UnitDescriptiveInfoRequestType
     * @uses UnitDescriptiveInfoRequestType::setUnitInfo()
     * @uses UnitDescriptiveInfoRequestType::setPolicies()
     * @uses UnitDescriptiveInfoRequestType::setUnitReviews()
     * @uses UnitDescriptiveInfoRequestType::setPromotions()
     * @uses UnitDescriptiveInfoRequestType::setPropertyManagerCode()
     * @uses UnitDescriptiveInfoRequestType::setUnitCode()
     * @uses UnitDescriptiveInfoRequestType::setUnitName()
     * @uses UnitDescriptiveInfoRequestType::setInfoSource()
     * @uses UnitDescriptiveInfoRequestType::setInternalUnitCode()
     * @uses UnitDescriptiveInfoRequestType::setUnitHeadline()
     * @uses UnitDescriptiveInfoRequestType::setPropertyURL()
     * @uses UnitDescriptiveInfoRequestType::setStateCodeList()
     * @uses UnitDescriptiveInfoRequestType::setCountryCodeList()
     * @uses UnitDescriptiveInfoRequestType::setBrandCodeList()
     * @uses UnitDescriptiveInfoRequestType::setMoreDataEchoToken()
     * @uses UnitDescriptiveInfoRequestType::setUpdatedAfter()
     * @param \rdyescapia\StructType\UnitInfo $unitInfo
     * @param \rdyescapia\StructType\Policies $policies
     * @param \rdyescapia\StructType\UnitReviews $unitReviews
     * @param \rdyescapia\StructType\Promotions $promotions
     * @param string $propertyManagerCode
     * @param string $unitCode
     * @param string $unitName
     * @param string $infoSource
     * @param string $internalUnitCode
     * @param string $unitHeadline
     * @param string $propertyURL
     * @param string[] $stateCodeList
     * @param string[] $countryCodeList
     * @param string[] $brandCodeList
     * @param string $moreDataEchoToken
     * @param string $updatedAfter
     */
    public function __construct(\rdyescapia\StructType\UnitInfo $unitInfo = null, \rdyescapia\StructType\Policies $policies = null, \rdyescapia\StructType\UnitReviews $unitReviews = null, \rdyescapia\StructType\Promotions $promotions = null, $propertyManagerCode = null, $unitCode = null, $unitName = null, $infoSource = null, $internalUnitCode = null, $unitHeadline = null, $propertyURL = null, array $stateCodeList = array(), array $countryCodeList = array(), array $brandCodeList = array(), $moreDataEchoToken = null, $updatedAfter = null)
    {
        $this
            ->setUnitInfo($unitInfo)
            ->setPolicies($policies)
            ->setUnitReviews($unitReviews)
            ->setPromotions($promotions)
            ->setPropertyManagerCode($propertyManagerCode)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName)
            ->setInfoSource($infoSource)
            ->setInternalUnitCode($internalUnitCode)
            ->setUnitHeadline($unitHeadline)
            ->setPropertyURL($propertyURL)
            ->setStateCodeList($stateCodeList)
            ->setCountryCodeList($countryCodeList)
            ->setBrandCodeList($brandCodeList)
            ->setMoreDataEchoToken($moreDataEchoToken)
            ->setUpdatedAfter($updatedAfter);
    }
    /**
     * Get UnitInfo value
     * @return \rdyescapia\StructType\UnitInfo|null
     */
    public function getUnitInfo()
    {
        return $this->UnitInfo;
    }
    /**
     * Set UnitInfo value
     * @param \rdyescapia\StructType\UnitInfo $unitInfo
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUnitInfo(\rdyescapia\StructType\UnitInfo $unitInfo = null)
    {
        $this->UnitInfo = $unitInfo;
        return $this;
    }
    /**
     * Get Policies value
     * @return \rdyescapia\StructType\Policies|null
     */
    public function getPolicies()
    {
        return $this->Policies;
    }
    /**
     * Set Policies value
     * @param \rdyescapia\StructType\Policies $policies
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setPolicies(\rdyescapia\StructType\Policies $policies = null)
    {
        $this->Policies = $policies;
        return $this;
    }
    /**
     * Get UnitReviews value
     * @return \rdyescapia\StructType\UnitReviews|null
     */
    public function getUnitReviews()
    {
        return $this->UnitReviews;
    }
    /**
     * Set UnitReviews value
     * @param \rdyescapia\StructType\UnitReviews $unitReviews
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUnitReviews(\rdyescapia\StructType\UnitReviews $unitReviews = null)
    {
        $this->UnitReviews = $unitReviews;
        return $this;
    }
    /**
     * Get Promotions value
     * @return \rdyescapia\StructType\Promotions|null
     */
    public function getPromotions()
    {
        return $this->Promotions;
    }
    /**
     * Set Promotions value
     * @param \rdyescapia\StructType\Promotions $promotions
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setPromotions(\rdyescapia\StructType\Promotions $promotions = null)
    {
        $this->Promotions = $promotions;
        return $this;
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyManagerCode, true), gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitName, true), gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get InternalUnitCode value
     * @return string|null
     */
    public function getInternalUnitCode()
    {
        return $this->InternalUnitCode;
    }
    /**
     * Set InternalUnitCode value
     * @param string $internalUnitCode
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setInternalUnitCode($internalUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalUnitCode) && !is_string($internalUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalUnitCode, true), gettype($internalUnitCode)), __LINE__);
        }
        $this->InternalUnitCode = $internalUnitCode;
        return $this;
    }
    /**
     * Get UnitHeadline value
     * @return string|null
     */
    public function getUnitHeadline()
    {
        return $this->UnitHeadline;
    }
    /**
     * Set UnitHeadline value
     * @param string $unitHeadline
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUnitHeadline($unitHeadline = null)
    {
        // validation for constraint: string
        if (!is_null($unitHeadline) && !is_string($unitHeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitHeadline, true), gettype($unitHeadline)), __LINE__);
        }
        $this->UnitHeadline = $unitHeadline;
        return $this;
    }
    /**
     * Get PropertyURL value
     * @return string|null
     */
    public function getPropertyURL()
    {
        return $this->PropertyURL;
    }
    /**
     * Set PropertyURL value
     * @param string $propertyURL
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setPropertyURL($propertyURL = null)
    {
        // validation for constraint: string
        if (!is_null($propertyURL) && !is_string($propertyURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyURL, true), gettype($propertyURL)), __LINE__);
        }
        $this->PropertyURL = $propertyURL;
        return $this;
    }
    /**
     * Get StateCodeList value
     * @return string[]|null
     */
    public function getStateCodeList()
    {
        return $this->StateCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setStateCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStateCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStateCodeListForArrayConstraintsFromSetStateCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitDescriptiveInfoRequestTypeStateCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($unitDescriptiveInfoRequestTypeStateCodeListItem)) {
                $invalidValues[] = is_object($unitDescriptiveInfoRequestTypeStateCodeListItem) ? get_class($unitDescriptiveInfoRequestTypeStateCodeListItem) : sprintf('%s(%s)', gettype($unitDescriptiveInfoRequestTypeStateCodeListItem), var_export($unitDescriptiveInfoRequestTypeStateCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StateCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StateCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $stateCodeList
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setStateCodeList(array $stateCodeList = array())
    {
        // validation for constraint: array
        if ('' !== ($stateCodeListArrayErrorMessage = self::validateStateCodeListForArrayConstraintsFromSetStateCodeList($stateCodeList))) {
            throw new \InvalidArgumentException($stateCodeListArrayErrorMessage, __LINE__);
        }
        $this->StateCodeList = $stateCodeList;
        return $this;
    }
    /**
     * Add item to StateCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function addToStateCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The StateCodeList property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StateCodeList[] = $item;
        return $this;
    }
    /**
     * Get CountryCodeList value
     * @return string[]|null
     */
    public function getCountryCodeList()
    {
        return $this->CountryCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setCountryCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountryCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountryCodeListForArrayConstraintsFromSetCountryCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitDescriptiveInfoRequestTypeCountryCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($unitDescriptiveInfoRequestTypeCountryCodeListItem)) {
                $invalidValues[] = is_object($unitDescriptiveInfoRequestTypeCountryCodeListItem) ? get_class($unitDescriptiveInfoRequestTypeCountryCodeListItem) : sprintf('%s(%s)', gettype($unitDescriptiveInfoRequestTypeCountryCodeListItem), var_export($unitDescriptiveInfoRequestTypeCountryCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CountryCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CountryCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $countryCodeList
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setCountryCodeList(array $countryCodeList = array())
    {
        // validation for constraint: array
        if ('' !== ($countryCodeListArrayErrorMessage = self::validateCountryCodeListForArrayConstraintsFromSetCountryCodeList($countryCodeList))) {
            throw new \InvalidArgumentException($countryCodeListArrayErrorMessage, __LINE__);
        }
        $this->CountryCodeList = $countryCodeList;
        return $this;
    }
    /**
     * Add item to CountryCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function addToCountryCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CountryCodeList property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CountryCodeList[] = $item;
        return $this;
    }
    /**
     * Get BrandCodeList value
     * @return string[]|null
     */
    public function getBrandCodeList()
    {
        return $this->BrandCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setBrandCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBrandCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBrandCodeListForArrayConstraintsFromSetBrandCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitDescriptiveInfoRequestTypeBrandCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($unitDescriptiveInfoRequestTypeBrandCodeListItem)) {
                $invalidValues[] = is_object($unitDescriptiveInfoRequestTypeBrandCodeListItem) ? get_class($unitDescriptiveInfoRequestTypeBrandCodeListItem) : sprintf('%s(%s)', gettype($unitDescriptiveInfoRequestTypeBrandCodeListItem), var_export($unitDescriptiveInfoRequestTypeBrandCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BrandCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BrandCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $brandCodeList
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setBrandCodeList(array $brandCodeList = array())
    {
        // validation for constraint: array
        if ('' !== ($brandCodeListArrayErrorMessage = self::validateBrandCodeListForArrayConstraintsFromSetBrandCodeList($brandCodeList))) {
            throw new \InvalidArgumentException($brandCodeListArrayErrorMessage, __LINE__);
        }
        $this->BrandCodeList = $brandCodeList;
        return $this;
    }
    /**
     * Add item to BrandCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function addToBrandCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BrandCodeList property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BrandCodeList[] = $item;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moreDataEchoToken, true), gettype($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Get UpdatedAfter value
     * @return string|null
     */
    public function getUpdatedAfter()
    {
        return $this->UpdatedAfter;
    }
    /**
     * Set UpdatedAfter value
     * @param string $updatedAfter
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public function setUpdatedAfter($updatedAfter = null)
    {
        // validation for constraint: string
        if (!is_null($updatedAfter) && !is_string($updatedAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedAfter, true), gettype($updatedAfter)), __LINE__);
        }
        $this->UpdatedAfter = $updatedAfter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitDescriptiveInfoRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
