<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomCategoryGroupType StructType
 * @subpackage Structs
 */
class CustomCategoryGroupType extends AbstractStructBase
{
    /**
     * The CustomCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CustomCategoryType[]
     */
    public $CustomCategory;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CustomCategoryGroupType
     * @uses CustomCategoryGroupType::setCustomCategory()
     * @uses CustomCategoryGroupType::setName()
     * @param \rdyescapia\StructType\CustomCategoryType[] $customCategory
     * @param string $name
     */
    public function __construct(array $customCategory = array(), $name = null)
    {
        $this
            ->setCustomCategory($customCategory)
            ->setName($name);
    }
    /**
     * Get CustomCategory value
     * @return \rdyescapia\StructType\CustomCategoryType[]|null
     */
    public function getCustomCategory()
    {
        return $this->CustomCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomCategoryForArrayConstraintsFromSetCustomCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customCategoryGroupTypeCustomCategoryItem) {
            // validation for constraint: itemType
            if (!$customCategoryGroupTypeCustomCategoryItem instanceof \rdyescapia\StructType\CustomCategoryType) {
                $invalidValues[] = is_object($customCategoryGroupTypeCustomCategoryItem) ? get_class($customCategoryGroupTypeCustomCategoryItem) : sprintf('%s(%s)', gettype($customCategoryGroupTypeCustomCategoryItem), var_export($customCategoryGroupTypeCustomCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomCategory property can only contain items of type \rdyescapia\StructType\CustomCategoryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomCategory value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CustomCategoryType[] $customCategory
     * @return \rdyescapia\StructType\CustomCategoryGroupType
     */
    public function setCustomCategory(array $customCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($customCategoryArrayErrorMessage = self::validateCustomCategoryForArrayConstraintsFromSetCustomCategory($customCategory))) {
            throw new \InvalidArgumentException($customCategoryArrayErrorMessage, __LINE__);
        }
        $this->CustomCategory = $customCategory;
        return $this;
    }
    /**
     * Add item to CustomCategory value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CustomCategoryType $item
     * @return \rdyescapia\StructType\CustomCategoryGroupType
     */
    public function addToCustomCategory(\rdyescapia\StructType\CustomCategoryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CustomCategoryType) {
            throw new \InvalidArgumentException(sprintf('The CustomCategory property can only contain items of type \rdyescapia\StructType\CustomCategoryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomCategory[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \rdyescapia\StructType\CustomCategoryGroupType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\CustomCategoryGroupType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
