<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlinePrefType StructType
 * @subpackage Structs
 */
class AirlinePrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\LoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The VendorPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The PaymentFormPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The AirportOriginPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AirportPrefType[]
     */
    public $AirportOriginPref;
    /**
     * The AirportRoutePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AirportPrefType[]
     */
    public $AirportRoutePref;
    /**
     * The FareRestrictPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\FareRestrictPref[]
     */
    public $FareRestrictPref;
    /**
     * The FlightTypePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\FlightTypePref[]
     */
    public $FlightTypePref;
    /**
     * The EquipPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EquipmentTypePref[]
     */
    public $EquipPref;
    /**
     * The CabinPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CabinPref[]
     */
    public $CabinPref;
    /**
     * The SeatPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SeatPref[]
     */
    public $SeatPref;
    /**
     * The TicketDistribPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TicketDistribPrefType[]
     */
    public $TicketDistribPref;
    /**
     * The MealPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\MealPrefType[]
     */
    public $MealPref;
    /**
     * The SpecRequestPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The SSR_Pref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SSR_Pref[]
     */
    public $SSR_Pref;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The MediaEntertainPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\MediaEntertainPrefType[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PetInfoPrefType[]
     */
    public $PetInfoPref;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The SmokingAllowed
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The PassengerTypeCode
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The AirTicketType
     * @var string
     */
    public $AirTicketType;
    /**
     * Constructor method for AirlinePrefType
     * @uses AirlinePrefType::setLoyaltyPref()
     * @uses AirlinePrefType::setVendorPref()
     * @uses AirlinePrefType::setPaymentFormPref()
     * @uses AirlinePrefType::setAirportOriginPref()
     * @uses AirlinePrefType::setAirportRoutePref()
     * @uses AirlinePrefType::setFareRestrictPref()
     * @uses AirlinePrefType::setFlightTypePref()
     * @uses AirlinePrefType::setEquipPref()
     * @uses AirlinePrefType::setCabinPref()
     * @uses AirlinePrefType::setSeatPref()
     * @uses AirlinePrefType::setTicketDistribPref()
     * @uses AirlinePrefType::setMealPref()
     * @uses AirlinePrefType::setSpecRequestPref()
     * @uses AirlinePrefType::setSSR_Pref()
     * @uses AirlinePrefType::setTPA_Extensions()
     * @uses AirlinePrefType::setMediaEntertainPref()
     * @uses AirlinePrefType::setPetInfoPref()
     * @uses AirlinePrefType::setShareSynchInd()
     * @uses AirlinePrefType::setShareMarketInd()
     * @uses AirlinePrefType::setPreferLevel()
     * @uses AirlinePrefType::setSmokingAllowed()
     * @uses AirlinePrefType::setPassengerTypeCode()
     * @uses AirlinePrefType::setAirTicketType()
     * @param \rdyescapia\StructType\LoyaltyPrefType[] $loyaltyPref
     * @param \rdyescapia\StructType\CompanyNamePrefType[] $vendorPref
     * @param \rdyescapia\StructType\PaymentFormPrefType[] $paymentFormPref
     * @param \rdyescapia\StructType\AirportPrefType[] $airportOriginPref
     * @param \rdyescapia\StructType\AirportPrefType[] $airportRoutePref
     * @param \rdyescapia\StructType\FareRestrictPref[] $fareRestrictPref
     * @param \rdyescapia\StructType\FlightTypePref[] $flightTypePref
     * @param \rdyescapia\StructType\EquipmentTypePref[] $equipPref
     * @param \rdyescapia\StructType\CabinPref[] $cabinPref
     * @param \rdyescapia\StructType\SeatPref[] $seatPref
     * @param \rdyescapia\StructType\TicketDistribPrefType[] $ticketDistribPref
     * @param \rdyescapia\StructType\MealPrefType[] $mealPref
     * @param \rdyescapia\StructType\SpecRequestPrefType[] $specRequestPref
     * @param \rdyescapia\StructType\SSR_Pref[] $sSR_Pref
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param \rdyescapia\StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @param \rdyescapia\StructType\PetInfoPrefType[] $petInfoPref
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $preferLevel
     * @param bool $smokingAllowed
     * @param string $passengerTypeCode
     * @param string $airTicketType
     */
    public function __construct(array $loyaltyPref = array(), array $vendorPref = array(), array $paymentFormPref = array(), array $airportOriginPref = array(), array $airportRoutePref = array(), array $fareRestrictPref = array(), array $flightTypePref = array(), array $equipPref = array(), array $cabinPref = array(), array $seatPref = array(), array $ticketDistribPref = array(), array $mealPref = array(), array $specRequestPref = array(), array $sSR_Pref = array(), \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null, array $mediaEntertainPref = array(), array $petInfoPref = array(), $shareSynchInd = null, $shareMarketInd = null, $preferLevel = 'Preferred', $smokingAllowed = false, $passengerTypeCode = null, $airTicketType = null)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setVendorPref($vendorPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setAirportOriginPref($airportOriginPref)
            ->setAirportRoutePref($airportRoutePref)
            ->setFareRestrictPref($fareRestrictPref)
            ->setFlightTypePref($flightTypePref)
            ->setEquipPref($equipPref)
            ->setCabinPref($cabinPref)
            ->setSeatPref($seatPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setMealPref($mealPref)
            ->setSpecRequestPref($specRequestPref)
            ->setSSR_Pref($sSR_Pref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setPreferLevel($preferLevel)
            ->setSmokingAllowed($smokingAllowed)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setAirTicketType($airTicketType);
    }
    /**
     * Get LoyaltyPref value
     * @return \rdyescapia\StructType\LoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeLoyaltyPrefItem instanceof \rdyescapia\StructType\LoyaltyPrefType) {
                $invalidValues[] = is_object($airlinePrefTypeLoyaltyPrefItem) ? get_class($airlinePrefTypeLoyaltyPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeLoyaltyPrefItem), var_export($airlinePrefTypeLoyaltyPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyPref property can only contain items of type \rdyescapia\StructType\LoyaltyPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyPrefType[] $loyaltyPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyPrefArrayErrorMessage = self::validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref($loyaltyPref))) {
            throw new \InvalidArgumentException($loyaltyPrefArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToLoyaltyPref(\rdyescapia\StructType\LoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\LoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of type \rdyescapia\StructType\LoyaltyPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \rdyescapia\StructType\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorPrefForArrayConstraintsFromSetVendorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeVendorPrefItem instanceof \rdyescapia\StructType\CompanyNamePrefType) {
                $invalidValues[] = is_object($airlinePrefTypeVendorPrefItem) ? get_class($airlinePrefTypeVendorPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeVendorPrefItem), var_export($airlinePrefTypeVendorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorPref property can only contain items of type \rdyescapia\StructType\CompanyNamePrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNamePrefType[] $vendorPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorPrefArrayErrorMessage = self::validateVendorPrefForArrayConstraintsFromSetVendorPref($vendorPref))) {
            throw new \InvalidArgumentException($vendorPrefArrayErrorMessage, __LINE__);
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNamePrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToVendorPref(\rdyescapia\StructType\CompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of type \rdyescapia\StructType\CompanyNamePrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \rdyescapia\StructType\PaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFormPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFormPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypePaymentFormPrefItem instanceof \rdyescapia\StructType\PaymentFormPrefType) {
                $invalidValues[] = is_object($airlinePrefTypePaymentFormPrefItem) ? get_class($airlinePrefTypePaymentFormPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypePaymentFormPrefItem), var_export($airlinePrefTypePaymentFormPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFormPref property can only contain items of type \rdyescapia\StructType\PaymentFormPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormPrefType[] $paymentFormPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormPrefArrayErrorMessage = self::validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref($paymentFormPref))) {
            throw new \InvalidArgumentException($paymentFormPrefArrayErrorMessage, __LINE__);
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToPaymentFormPref(\rdyescapia\StructType\PaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of type \rdyescapia\StructType\PaymentFormPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get AirportOriginPref value
     * @return \rdyescapia\StructType\AirportPrefType[]|null
     */
    public function getAirportOriginPref()
    {
        return $this->AirportOriginPref;
    }
    /**
     * This method is responsible for validating the values passed to the setAirportOriginPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirportOriginPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirportOriginPrefForArrayConstraintsFromSetAirportOriginPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeAirportOriginPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeAirportOriginPrefItem instanceof \rdyescapia\StructType\AirportPrefType) {
                $invalidValues[] = is_object($airlinePrefTypeAirportOriginPrefItem) ? get_class($airlinePrefTypeAirportOriginPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeAirportOriginPrefItem), var_export($airlinePrefTypeAirportOriginPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirportOriginPref property can only contain items of type \rdyescapia\StructType\AirportPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirportOriginPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AirportPrefType[] $airportOriginPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setAirportOriginPref(array $airportOriginPref = array())
    {
        // validation for constraint: array
        if ('' !== ($airportOriginPrefArrayErrorMessage = self::validateAirportOriginPrefForArrayConstraintsFromSetAirportOriginPref($airportOriginPref))) {
            throw new \InvalidArgumentException($airportOriginPrefArrayErrorMessage, __LINE__);
        }
        $this->AirportOriginPref = $airportOriginPref;
        return $this;
    }
    /**
     * Add item to AirportOriginPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AirportPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToAirportOriginPref(\rdyescapia\StructType\AirportPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AirportPrefType) {
            throw new \InvalidArgumentException(sprintf('The AirportOriginPref property can only contain items of type \rdyescapia\StructType\AirportPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirportOriginPref[] = $item;
        return $this;
    }
    /**
     * Get AirportRoutePref value
     * @return \rdyescapia\StructType\AirportPrefType[]|null
     */
    public function getAirportRoutePref()
    {
        return $this->AirportRoutePref;
    }
    /**
     * This method is responsible for validating the values passed to the setAirportRoutePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirportRoutePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirportRoutePrefForArrayConstraintsFromSetAirportRoutePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeAirportRoutePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeAirportRoutePrefItem instanceof \rdyescapia\StructType\AirportPrefType) {
                $invalidValues[] = is_object($airlinePrefTypeAirportRoutePrefItem) ? get_class($airlinePrefTypeAirportRoutePrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeAirportRoutePrefItem), var_export($airlinePrefTypeAirportRoutePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirportRoutePref property can only contain items of type \rdyescapia\StructType\AirportPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirportRoutePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AirportPrefType[] $airportRoutePref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setAirportRoutePref(array $airportRoutePref = array())
    {
        // validation for constraint: array
        if ('' !== ($airportRoutePrefArrayErrorMessage = self::validateAirportRoutePrefForArrayConstraintsFromSetAirportRoutePref($airportRoutePref))) {
            throw new \InvalidArgumentException($airportRoutePrefArrayErrorMessage, __LINE__);
        }
        $this->AirportRoutePref = $airportRoutePref;
        return $this;
    }
    /**
     * Add item to AirportRoutePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AirportPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToAirportRoutePref(\rdyescapia\StructType\AirportPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AirportPrefType) {
            throw new \InvalidArgumentException(sprintf('The AirportRoutePref property can only contain items of type \rdyescapia\StructType\AirportPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirportRoutePref[] = $item;
        return $this;
    }
    /**
     * Get FareRestrictPref value
     * @return \rdyescapia\StructType\FareRestrictPref[]|null
     */
    public function getFareRestrictPref()
    {
        return $this->FareRestrictPref;
    }
    /**
     * This method is responsible for validating the values passed to the setFareRestrictPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareRestrictPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareRestrictPrefForArrayConstraintsFromSetFareRestrictPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeFareRestrictPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFareRestrictPrefItem instanceof \rdyescapia\StructType\FareRestrictPref) {
                $invalidValues[] = is_object($airlinePrefTypeFareRestrictPrefItem) ? get_class($airlinePrefTypeFareRestrictPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeFareRestrictPrefItem), var_export($airlinePrefTypeFareRestrictPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareRestrictPref property can only contain items of type \rdyescapia\StructType\FareRestrictPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FareRestrictPref[] $fareRestrictPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setFareRestrictPref(array $fareRestrictPref = array())
    {
        // validation for constraint: array
        if ('' !== ($fareRestrictPrefArrayErrorMessage = self::validateFareRestrictPrefForArrayConstraintsFromSetFareRestrictPref($fareRestrictPref))) {
            throw new \InvalidArgumentException($fareRestrictPrefArrayErrorMessage, __LINE__);
        }
        $this->FareRestrictPref = $fareRestrictPref;
        return $this;
    }
    /**
     * Add item to FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FareRestrictPref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToFareRestrictPref(\rdyescapia\StructType\FareRestrictPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\FareRestrictPref) {
            throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of type \rdyescapia\StructType\FareRestrictPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareRestrictPref[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \rdyescapia\StructType\FlightTypePref[]|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightTypePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightTypePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightTypePrefForArrayConstraintsFromSetFlightTypePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeFlightTypePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFlightTypePrefItem instanceof \rdyescapia\StructType\FlightTypePref) {
                $invalidValues[] = is_object($airlinePrefTypeFlightTypePrefItem) ? get_class($airlinePrefTypeFlightTypePrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeFlightTypePrefItem), var_export($airlinePrefTypeFlightTypePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightTypePref property can only contain items of type \rdyescapia\StructType\FlightTypePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FlightTypePref[] $flightTypePref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setFlightTypePref(array $flightTypePref = array())
    {
        // validation for constraint: array
        if ('' !== ($flightTypePrefArrayErrorMessage = self::validateFlightTypePrefForArrayConstraintsFromSetFlightTypePref($flightTypePref))) {
            throw new \InvalidArgumentException($flightTypePrefArrayErrorMessage, __LINE__);
        }
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Add item to FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FlightTypePref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToFlightTypePref(\rdyescapia\StructType\FlightTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\FlightTypePref) {
            throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of type \rdyescapia\StructType\FlightTypePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FlightTypePref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return \rdyescapia\StructType\EquipmentTypePref[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * This method is responsible for validating the values passed to the setEquipPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquipPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquipPrefForArrayConstraintsFromSetEquipPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeEquipPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeEquipPrefItem instanceof \rdyescapia\StructType\EquipmentTypePref) {
                $invalidValues[] = is_object($airlinePrefTypeEquipPrefItem) ? get_class($airlinePrefTypeEquipPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeEquipPrefItem), var_export($airlinePrefTypeEquipPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EquipPref property can only contain items of type \rdyescapia\StructType\EquipmentTypePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EquipPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EquipmentTypePref[] $equipPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setEquipPref(array $equipPref = array())
    {
        // validation for constraint: array
        if ('' !== ($equipPrefArrayErrorMessage = self::validateEquipPrefForArrayConstraintsFromSetEquipPref($equipPref))) {
            throw new \InvalidArgumentException($equipPrefArrayErrorMessage, __LINE__);
        }
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EquipmentTypePref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToEquipPref(\rdyescapia\StructType\EquipmentTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EquipmentTypePref) {
            throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of type \rdyescapia\StructType\EquipmentTypePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \rdyescapia\StructType\CabinPref[]|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinPrefForArrayConstraintsFromSetCabinPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeCabinPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeCabinPrefItem instanceof \rdyescapia\StructType\CabinPref) {
                $invalidValues[] = is_object($airlinePrefTypeCabinPrefItem) ? get_class($airlinePrefTypeCabinPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeCabinPrefItem), var_export($airlinePrefTypeCabinPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinPref property can only contain items of type \rdyescapia\StructType\CabinPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CabinPref[] $cabinPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setCabinPref(array $cabinPref = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinPrefArrayErrorMessage = self::validateCabinPrefForArrayConstraintsFromSetCabinPref($cabinPref))) {
            throw new \InvalidArgumentException($cabinPrefArrayErrorMessage, __LINE__);
        }
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Add item to CabinPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CabinPref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToCabinPref(\rdyescapia\StructType\CabinPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CabinPref) {
            throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of type \rdyescapia\StructType\CabinPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CabinPref[] = $item;
        return $this;
    }
    /**
     * Get SeatPref value
     * @return \rdyescapia\StructType\SeatPref[]|null
     */
    public function getSeatPref()
    {
        return $this->SeatPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatPrefForArrayConstraintsFromSetSeatPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeSeatPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSeatPrefItem instanceof \rdyescapia\StructType\SeatPref) {
                $invalidValues[] = is_object($airlinePrefTypeSeatPrefItem) ? get_class($airlinePrefTypeSeatPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeSeatPrefItem), var_export($airlinePrefTypeSeatPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatPref property can only contain items of type \rdyescapia\StructType\SeatPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SeatPref[] $seatPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setSeatPref(array $seatPref = array())
    {
        // validation for constraint: array
        if ('' !== ($seatPrefArrayErrorMessage = self::validateSeatPrefForArrayConstraintsFromSetSeatPref($seatPref))) {
            throw new \InvalidArgumentException($seatPrefArrayErrorMessage, __LINE__);
        }
        $this->SeatPref = $seatPref;
        return $this;
    }
    /**
     * Add item to SeatPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SeatPref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToSeatPref(\rdyescapia\StructType\SeatPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SeatPref) {
            throw new \InvalidArgumentException(sprintf('The SeatPref property can only contain items of type \rdyescapia\StructType\SeatPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \rdyescapia\StructType\TicketDistribPrefType[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDistribPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDistribPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeTicketDistribPrefItem instanceof \rdyescapia\StructType\TicketDistribPrefType) {
                $invalidValues[] = is_object($airlinePrefTypeTicketDistribPrefItem) ? get_class($airlinePrefTypeTicketDistribPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeTicketDistribPrefItem), var_export($airlinePrefTypeTicketDistribPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDistribPref property can only contain items of type \rdyescapia\StructType\TicketDistribPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TicketDistribPrefType[] $ticketDistribPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDistribPrefArrayErrorMessage = self::validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref($ticketDistribPref))) {
            throw new \InvalidArgumentException($ticketDistribPrefArrayErrorMessage, __LINE__);
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TicketDistribPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToTicketDistribPref(\rdyescapia\StructType\TicketDistribPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TicketDistribPrefType) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of type \rdyescapia\StructType\TicketDistribPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return \rdyescapia\StructType\MealPrefType[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * This method is responsible for validating the values passed to the setMealPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMealPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMealPrefForArrayConstraintsFromSetMealPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeMealPrefItem instanceof \rdyescapia\StructType\MealPrefType) {
                $invalidValues[] = is_object($airlinePrefTypeMealPrefItem) ? get_class($airlinePrefTypeMealPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeMealPrefItem), var_export($airlinePrefTypeMealPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MealPref property can only contain items of type \rdyescapia\StructType\MealPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MealPrefType[] $mealPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        // validation for constraint: array
        if ('' !== ($mealPrefArrayErrorMessage = self::validateMealPrefForArrayConstraintsFromSetMealPref($mealPref))) {
            throw new \InvalidArgumentException($mealPrefArrayErrorMessage, __LINE__);
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MealPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToMealPref(\rdyescapia\StructType\MealPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\MealPrefType) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of type \rdyescapia\StructType\MealPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \rdyescapia\StructType\SpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecRequestPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecRequestPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSpecRequestPrefItem instanceof \rdyescapia\StructType\SpecRequestPrefType) {
                $invalidValues[] = is_object($airlinePrefTypeSpecRequestPrefItem) ? get_class($airlinePrefTypeSpecRequestPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeSpecRequestPrefItem), var_export($airlinePrefTypeSpecRequestPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecRequestPref property can only contain items of type \rdyescapia\StructType\SpecRequestPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecRequestPrefType[] $specRequestPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specRequestPrefArrayErrorMessage = self::validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref($specRequestPref))) {
            throw new \InvalidArgumentException($specRequestPrefArrayErrorMessage, __LINE__);
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecRequestPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToSpecRequestPref(\rdyescapia\StructType\SpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of type \rdyescapia\StructType\SpecRequestPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get SSR_Pref value
     * @return \rdyescapia\StructType\SSR_Pref[]|null
     */
    public function getSSR_Pref()
    {
        return $this->SSR_Pref;
    }
    /**
     * This method is responsible for validating the values passed to the setSSR_Pref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSSR_Pref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSSR_PrefForArrayConstraintsFromSetSSR_Pref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeSSR_PrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSSR_PrefItem instanceof \rdyescapia\StructType\SSR_Pref) {
                $invalidValues[] = is_object($airlinePrefTypeSSR_PrefItem) ? get_class($airlinePrefTypeSSR_PrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeSSR_PrefItem), var_export($airlinePrefTypeSSR_PrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SSR_Pref property can only contain items of type \rdyescapia\StructType\SSR_Pref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SSR_Pref[] $sSR_Pref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setSSR_Pref(array $sSR_Pref = array())
    {
        // validation for constraint: array
        if ('' !== ($sSR_PrefArrayErrorMessage = self::validateSSR_PrefForArrayConstraintsFromSetSSR_Pref($sSR_Pref))) {
            throw new \InvalidArgumentException($sSR_PrefArrayErrorMessage, __LINE__);
        }
        $this->SSR_Pref = $sSR_Pref;
        return $this;
    }
    /**
     * Add item to SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SSR_Pref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToSSR_Pref(\rdyescapia\StructType\SSR_Pref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SSR_Pref) {
            throw new \InvalidArgumentException(sprintf('The SSR_Pref property can only contain items of type \rdyescapia\StructType\SSR_Pref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SSR_Pref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return \rdyescapia\StructType\MediaEntertainPrefType[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaEntertainPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaEntertainPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaEntertainPrefForArrayConstraintsFromSetMediaEntertainPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeMediaEntertainPrefItem instanceof \rdyescapia\StructType\MediaEntertainPrefType) {
                $invalidValues[] = is_object($airlinePrefTypeMediaEntertainPrefItem) ? get_class($airlinePrefTypeMediaEntertainPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeMediaEntertainPrefItem), var_export($airlinePrefTypeMediaEntertainPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MediaEntertainPref property can only contain items of type \rdyescapia\StructType\MediaEntertainPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaEntertainPrefArrayErrorMessage = self::validateMediaEntertainPrefForArrayConstraintsFromSetMediaEntertainPref($mediaEntertainPref))) {
            throw new \InvalidArgumentException($mediaEntertainPrefArrayErrorMessage, __LINE__);
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MediaEntertainPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToMediaEntertainPref(\rdyescapia\StructType\MediaEntertainPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\MediaEntertainPrefType) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of type \rdyescapia\StructType\MediaEntertainPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return \rdyescapia\StructType\PetInfoPrefType[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPetInfoPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPetInfoPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePetInfoPrefForArrayConstraintsFromSetPetInfoPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypePetInfoPrefItem instanceof \rdyescapia\StructType\PetInfoPrefType) {
                $invalidValues[] = is_object($airlinePrefTypePetInfoPrefItem) ? get_class($airlinePrefTypePetInfoPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypePetInfoPrefItem), var_export($airlinePrefTypePetInfoPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PetInfoPref property can only contain items of type \rdyescapia\StructType\PetInfoPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PetInfoPrefType[] $petInfoPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        // validation for constraint: array
        if ('' !== ($petInfoPrefArrayErrorMessage = self::validatePetInfoPrefForArrayConstraintsFromSetPetInfoPref($petInfoPref))) {
            throw new \InvalidArgumentException($petInfoPrefArrayErrorMessage, __LINE__);
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PetInfoPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToPetInfoPref(\rdyescapia\StructType\PetInfoPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PetInfoPrefType) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of type \rdyescapia\StructType\PetInfoPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get AirTicketType value
     * @return string|null
     */
    public function getAirTicketType()
    {
        return $this->AirTicketType;
    }
    /**
     * Set AirTicketType value
     * @uses \rdyescapia\EnumType\TicketType::valueIsValid()
     * @uses \rdyescapia\EnumType\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airTicketType
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setAirTicketType($airTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\TicketType::valueIsValid($airTicketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\TicketType', is_array($airTicketType) ? implode(', ', $airTicketType) : var_export($airTicketType, true), implode(', ', \rdyescapia\EnumType\TicketType::getValidValues())), __LINE__);
        }
        $this->AirTicketType = $airTicketType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
