<?php

namespace rdyescapia\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Booking ServiceType
 * @subpackage Services
 */
class Booking extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BookingChannels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_BookingChannelsRQ $eVRN_BookingChannelsRQ
     * @return \rdyescapia\StructType\EVRN_BookingChannelsRS|bool
     */
    public function BookingChannels(\rdyescapia\StructType\EVRN_BookingChannelsRQ $eVRN_BookingChannelsRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->BookingChannels($eVRN_BookingChannelsRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \rdyescapia\StructType\EVRN_BookingChannelsRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
