<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSearchCriterionType StructType
 * @subpackage Structs
 */
class ItemSearchCriterionType extends AbstractStructBase
{
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Position
     */
    public $Position;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Address
     */
    public $Address;
    /**
     * The UnitRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitRef
     */
    public $UnitRef;
    /**
     * The Radius
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Radius
     */
    public $Radius;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\RegionType
     */
    public $Region;
    /**
     * The ExactMatch
     * @var bool
     */
    public $ExactMatch;
    /**
     * The ImportanceType
     * @var string
     */
    public $ImportanceType;
    /**
     * The Ranking
     * @var int
     */
    public $Ranking;
    /**
     * Constructor method for ItemSearchCriterionType
     * @uses ItemSearchCriterionType::setPosition()
     * @uses ItemSearchCriterionType::setAddress()
     * @uses ItemSearchCriterionType::setUnitRef()
     * @uses ItemSearchCriterionType::setRadius()
     * @uses ItemSearchCriterionType::setRegion()
     * @uses ItemSearchCriterionType::setExactMatch()
     * @uses ItemSearchCriterionType::setImportanceType()
     * @uses ItemSearchCriterionType::setRanking()
     * @param \rdyescapia\StructType\Position $position
     * @param \rdyescapia\StructType\Address $address
     * @param \rdyescapia\StructType\UnitRef $unitRef
     * @param \rdyescapia\StructType\Radius $radius
     * @param \rdyescapia\StructType\RegionType $region
     * @param bool $exactMatch
     * @param string $importanceType
     * @param int $ranking
     */
    public function __construct(\rdyescapia\StructType\Position $position = null, \rdyescapia\StructType\Address $address = null, \rdyescapia\StructType\UnitRef $unitRef = null, \rdyescapia\StructType\Radius $radius = null, \rdyescapia\StructType\RegionType $region = null, $exactMatch = null, $importanceType = null, $ranking = null)
    {
        $this
            ->setPosition($position)
            ->setAddress($address)
            ->setUnitRef($unitRef)
            ->setRadius($radius)
            ->setRegion($region)
            ->setExactMatch($exactMatch)
            ->setImportanceType($importanceType)
            ->setRanking($ranking);
    }
    /**
     * Get Position value
     * @return \rdyescapia\StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \rdyescapia\StructType\Position $position
     * @return \rdyescapia\StructType\ItemSearchCriterionType
     */
    public function setPosition(\rdyescapia\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return \rdyescapia\StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \rdyescapia\StructType\Address $address
     * @return \rdyescapia\StructType\ItemSearchCriterionType
     */
    public function setAddress(\rdyescapia\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get UnitRef value
     * @return \rdyescapia\StructType\UnitRef|null
     */
    public function getUnitRef()
    {
        return $this->UnitRef;
    }
    /**
     * Set UnitRef value
     * @param \rdyescapia\StructType\UnitRef $unitRef
     * @return \rdyescapia\StructType\ItemSearchCriterionType
     */
    public function setUnitRef(\rdyescapia\StructType\UnitRef $unitRef = null)
    {
        $this->UnitRef = $unitRef;
        return $this;
    }
    /**
     * Get Radius value
     * @return \rdyescapia\StructType\Radius|null
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param \rdyescapia\StructType\Radius $radius
     * @return \rdyescapia\StructType\ItemSearchCriterionType
     */
    public function setRadius(\rdyescapia\StructType\Radius $radius = null)
    {
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get Region value
     * @return \rdyescapia\StructType\RegionType|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param \rdyescapia\StructType\RegionType $region
     * @return \rdyescapia\StructType\ItemSearchCriterionType
     */
    public function setRegion(\rdyescapia\StructType\RegionType $region = null)
    {
        $this->Region = $region;
        return $this;
    }
    /**
     * Get ExactMatch value
     * @return bool|null
     */
    public function getExactMatch()
    {
        return $this->ExactMatch;
    }
    /**
     * Set ExactMatch value
     * @param bool $exactMatch
     * @return \rdyescapia\StructType\ItemSearchCriterionType
     */
    public function setExactMatch($exactMatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($exactMatch) && !is_bool($exactMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exactMatch, true), gettype($exactMatch)), __LINE__);
        }
        $this->ExactMatch = $exactMatch;
        return $this;
    }
    /**
     * Get ImportanceType value
     * @return string|null
     */
    public function getImportanceType()
    {
        return $this->ImportanceType;
    }
    /**
     * Set ImportanceType value
     * @param string $importanceType
     * @return \rdyescapia\StructType\ItemSearchCriterionType
     */
    public function setImportanceType($importanceType = null)
    {
        // validation for constraint: string
        if (!is_null($importanceType) && !is_string($importanceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importanceType, true), gettype($importanceType)), __LINE__);
        }
        $this->ImportanceType = $importanceType;
        return $this;
    }
    /**
     * Get Ranking value
     * @return int|null
     */
    public function getRanking()
    {
        return $this->Ranking;
    }
    /**
     * Set Ranking value
     * @param int $ranking
     * @return \rdyescapia\StructType\ItemSearchCriterionType
     */
    public function setRanking($ranking = null)
    {
        // validation for constraint: int
        if (!is_null($ranking) && !(is_int($ranking) || ctype_digit($ranking))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ranking, true), gettype($ranking)), __LINE__);
        }
        $this->Ranking = $ranking;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\ItemSearchCriterionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
