<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignType StructType
 * @subpackage Structs
 */
class CampaignType extends AbstractStructBase
{
    /**
     * The CampaignKeywordReferral
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CampaignKeywordReferralType[]
     */
    public $CampaignKeywordReferral;
    /**
     * The Campaign_ID
     * @var int
     */
    public $Campaign_ID;
    /**
     * The TollFreeNumber
     * @var string
     */
    public $TollFreeNumber;
    /**
     * The CreationDate
     * @var string
     */
    public $CreationDate;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpirationDate
     * @var string
     */
    public $ExpirationDate;
    /**
     * The UpdatedDate
     * @var string
     */
    public $UpdatedDate;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The IsActive
     * @var bool
     */
    public $IsActive;
    /**
     * The IsDeleted
     * @var bool
     */
    public $IsDeleted;
    /**
     * Constructor method for CampaignType
     * @uses CampaignType::setCampaignKeywordReferral()
     * @uses CampaignType::setCampaign_ID()
     * @uses CampaignType::setTollFreeNumber()
     * @uses CampaignType::setCreationDate()
     * @uses CampaignType::setEffectiveDate()
     * @uses CampaignType::setExpirationDate()
     * @uses CampaignType::setUpdatedDate()
     * @uses CampaignType::setName()
     * @uses CampaignType::setIsActive()
     * @uses CampaignType::setIsDeleted()
     * @param \rdyescapia\StructType\CampaignKeywordReferralType[] $campaignKeywordReferral
     * @param int $campaign_ID
     * @param string $tollFreeNumber
     * @param string $creationDate
     * @param string $effectiveDate
     * @param string $expirationDate
     * @param string $updatedDate
     * @param string $name
     * @param bool $isActive
     * @param bool $isDeleted
     */
    public function __construct(array $campaignKeywordReferral = array(), $campaign_ID = null, $tollFreeNumber = null, $creationDate = null, $effectiveDate = null, $expirationDate = null, $updatedDate = null, $name = null, $isActive = null, $isDeleted = null)
    {
        $this
            ->setCampaignKeywordReferral($campaignKeywordReferral)
            ->setCampaign_ID($campaign_ID)
            ->setTollFreeNumber($tollFreeNumber)
            ->setCreationDate($creationDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate)
            ->setUpdatedDate($updatedDate)
            ->setName($name)
            ->setIsActive($isActive)
            ->setIsDeleted($isDeleted);
    }
    /**
     * Get CampaignKeywordReferral value
     * @return \rdyescapia\StructType\CampaignKeywordReferralType[]|null
     */
    public function getCampaignKeywordReferral()
    {
        return $this->CampaignKeywordReferral;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaignKeywordReferral method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaignKeywordReferral method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignKeywordReferralForArrayConstraintsFromSetCampaignKeywordReferral(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $campaignTypeCampaignKeywordReferralItem) {
            // validation for constraint: itemType
            if (!$campaignTypeCampaignKeywordReferralItem instanceof \rdyescapia\StructType\CampaignKeywordReferralType) {
                $invalidValues[] = is_object($campaignTypeCampaignKeywordReferralItem) ? get_class($campaignTypeCampaignKeywordReferralItem) : sprintf('%s(%s)', gettype($campaignTypeCampaignKeywordReferralItem), var_export($campaignTypeCampaignKeywordReferralItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CampaignKeywordReferral property can only contain items of type \rdyescapia\StructType\CampaignKeywordReferralType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CampaignKeywordReferral value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CampaignKeywordReferralType[] $campaignKeywordReferral
     * @return \rdyescapia\StructType\CampaignType
     */
    public function setCampaignKeywordReferral(array $campaignKeywordReferral = array())
    {
        // validation for constraint: array
        if ('' !== ($campaignKeywordReferralArrayErrorMessage = self::validateCampaignKeywordReferralForArrayConstraintsFromSetCampaignKeywordReferral($campaignKeywordReferral))) {
            throw new \InvalidArgumentException($campaignKeywordReferralArrayErrorMessage, __LINE__);
        }
        $this->CampaignKeywordReferral = $campaignKeywordReferral;
        return $this;
    }
    /**
     * Add item to CampaignKeywordReferral value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CampaignKeywordReferralType $item
     * @return \rdyescapia\StructType\CampaignType
     */
    public function addToCampaignKeywordReferral(\rdyescapia\StructType\CampaignKeywordReferralType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CampaignKeywordReferralType) {
            throw new \InvalidArgumentException(sprintf('The CampaignKeywordReferral property can only contain items of type \rdyescapia\StructType\CampaignKeywordReferralType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CampaignKeywordReferral[] = $item;
        return $this;
    }
    /**
     * Get Campaign_ID value
     * @return int|null
     */
    public function getCampaign_ID()
    {
        return $this->Campaign_ID;
    }
    /**
     * Set Campaign_ID value
     * @param int $campaign_ID
     * @return \rdyescapia\StructType\CampaignType
     */
    public function setCampaign_ID($campaign_ID = null)
    {
        // validation for constraint: int
        if (!is_null($campaign_ID) && !(is_int($campaign_ID) || ctype_digit($campaign_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaign_ID, true), gettype($campaign_ID)), __LINE__);
        }
        $this->Campaign_ID = $campaign_ID;
        return $this;
    }
    /**
     * Get TollFreeNumber value
     * @return string|null
     */
    public function getTollFreeNumber()
    {
        return $this->TollFreeNumber;
    }
    /**
     * Set TollFreeNumber value
     * @param string $tollFreeNumber
     * @return \rdyescapia\StructType\CampaignType
     */
    public function setTollFreeNumber($tollFreeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tollFreeNumber) && !is_string($tollFreeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tollFreeNumber, true), gettype($tollFreeNumber)), __LINE__);
        }
        $this->TollFreeNumber = $tollFreeNumber;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \rdyescapia\StructType\CampaignType
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \rdyescapia\StructType\CampaignType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \rdyescapia\StructType\CampaignType
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get UpdatedDate value
     * @return string|null
     */
    public function getUpdatedDate()
    {
        return $this->UpdatedDate;
    }
    /**
     * Set UpdatedDate value
     * @param string $updatedDate
     * @return \rdyescapia\StructType\CampaignType
     */
    public function setUpdatedDate($updatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($updatedDate) && !is_string($updatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedDate, true), gettype($updatedDate)), __LINE__);
        }
        $this->UpdatedDate = $updatedDate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \rdyescapia\StructType\CampaignType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \rdyescapia\StructType\CampaignType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \rdyescapia\StructType\CampaignType
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\CampaignType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
