<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgreementsType StructType
 * @subpackage Structs
 */
class AgreementsType extends AbstractStructBase
{
    /**
     * The Certification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CertificationType[]
     */
    public $Certification;
    /**
     * The AllianceConsortium
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AllianceConsortiumType[]
     */
    public $AllianceConsortium;
    /**
     * The CommissionInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CommissionInfoType[]
     */
    public $CommissionInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for AgreementsType
     * @uses AgreementsType::setCertification()
     * @uses AgreementsType::setAllianceConsortium()
     * @uses AgreementsType::setCommissionInfo()
     * @uses AgreementsType::setTPA_Extensions()
     * @uses AgreementsType::setShareSynchInd()
     * @uses AgreementsType::setShareMarketInd()
     * @param \rdyescapia\StructType\CertificationType[] $certification
     * @param \rdyescapia\StructType\AllianceConsortiumType[] $allianceConsortium
     * @param \rdyescapia\StructType\CommissionInfoType[] $commissionInfo
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $certification = array(), array $allianceConsortium = array(), array $commissionInfo = array(), \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setCertification($certification)
            ->setAllianceConsortium($allianceConsortium)
            ->setCommissionInfo($commissionInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get Certification value
     * @return \rdyescapia\StructType\CertificationType[]|null
     */
    public function getCertification()
    {
        return $this->Certification;
    }
    /**
     * This method is responsible for validating the values passed to the setCertification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCertification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCertificationForArrayConstraintsFromSetCertification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agreementsTypeCertificationItem) {
            // validation for constraint: itemType
            if (!$agreementsTypeCertificationItem instanceof \rdyescapia\StructType\CertificationType) {
                $invalidValues[] = is_object($agreementsTypeCertificationItem) ? get_class($agreementsTypeCertificationItem) : sprintf('%s(%s)', gettype($agreementsTypeCertificationItem), var_export($agreementsTypeCertificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Certification property can only contain items of type \rdyescapia\StructType\CertificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Certification value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CertificationType[] $certification
     * @return \rdyescapia\StructType\AgreementsType
     */
    public function setCertification(array $certification = array())
    {
        // validation for constraint: array
        if ('' !== ($certificationArrayErrorMessage = self::validateCertificationForArrayConstraintsFromSetCertification($certification))) {
            throw new \InvalidArgumentException($certificationArrayErrorMessage, __LINE__);
        }
        $this->Certification = $certification;
        return $this;
    }
    /**
     * Add item to Certification value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CertificationType $item
     * @return \rdyescapia\StructType\AgreementsType
     */
    public function addToCertification(\rdyescapia\StructType\CertificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CertificationType) {
            throw new \InvalidArgumentException(sprintf('The Certification property can only contain items of type \rdyescapia\StructType\CertificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Certification[] = $item;
        return $this;
    }
    /**
     * Get AllianceConsortium value
     * @return \rdyescapia\StructType\AllianceConsortiumType[]|null
     */
    public function getAllianceConsortium()
    {
        return $this->AllianceConsortium;
    }
    /**
     * This method is responsible for validating the values passed to the setAllianceConsortium method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllianceConsortium method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllianceConsortiumForArrayConstraintsFromSetAllianceConsortium(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agreementsTypeAllianceConsortiumItem) {
            // validation for constraint: itemType
            if (!$agreementsTypeAllianceConsortiumItem instanceof \rdyescapia\StructType\AllianceConsortiumType) {
                $invalidValues[] = is_object($agreementsTypeAllianceConsortiumItem) ? get_class($agreementsTypeAllianceConsortiumItem) : sprintf('%s(%s)', gettype($agreementsTypeAllianceConsortiumItem), var_export($agreementsTypeAllianceConsortiumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllianceConsortium property can only contain items of type \rdyescapia\StructType\AllianceConsortiumType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllianceConsortium value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AllianceConsortiumType[] $allianceConsortium
     * @return \rdyescapia\StructType\AgreementsType
     */
    public function setAllianceConsortium(array $allianceConsortium = array())
    {
        // validation for constraint: array
        if ('' !== ($allianceConsortiumArrayErrorMessage = self::validateAllianceConsortiumForArrayConstraintsFromSetAllianceConsortium($allianceConsortium))) {
            throw new \InvalidArgumentException($allianceConsortiumArrayErrorMessage, __LINE__);
        }
        $this->AllianceConsortium = $allianceConsortium;
        return $this;
    }
    /**
     * Add item to AllianceConsortium value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AllianceConsortiumType $item
     * @return \rdyescapia\StructType\AgreementsType
     */
    public function addToAllianceConsortium(\rdyescapia\StructType\AllianceConsortiumType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AllianceConsortiumType) {
            throw new \InvalidArgumentException(sprintf('The AllianceConsortium property can only contain items of type \rdyescapia\StructType\AllianceConsortiumType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllianceConsortium[] = $item;
        return $this;
    }
    /**
     * Get CommissionInfo value
     * @return \rdyescapia\StructType\CommissionInfoType[]|null
     */
    public function getCommissionInfo()
    {
        return $this->CommissionInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setCommissionInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommissionInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionInfoForArrayConstraintsFromSetCommissionInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agreementsTypeCommissionInfoItem) {
            // validation for constraint: itemType
            if (!$agreementsTypeCommissionInfoItem instanceof \rdyescapia\StructType\CommissionInfoType) {
                $invalidValues[] = is_object($agreementsTypeCommissionInfoItem) ? get_class($agreementsTypeCommissionInfoItem) : sprintf('%s(%s)', gettype($agreementsTypeCommissionInfoItem), var_export($agreementsTypeCommissionInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommissionInfo property can only contain items of type \rdyescapia\StructType\CommissionInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommissionInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CommissionInfoType[] $commissionInfo
     * @return \rdyescapia\StructType\AgreementsType
     */
    public function setCommissionInfo(array $commissionInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionInfoArrayErrorMessage = self::validateCommissionInfoForArrayConstraintsFromSetCommissionInfo($commissionInfo))) {
            throw new \InvalidArgumentException($commissionInfoArrayErrorMessage, __LINE__);
        }
        $this->CommissionInfo = $commissionInfo;
        return $this;
    }
    /**
     * Add item to CommissionInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CommissionInfoType $item
     * @return \rdyescapia\StructType\AgreementsType
     */
    public function addToCommissionInfo(\rdyescapia\StructType\CommissionInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CommissionInfoType) {
            throw new \InvalidArgumentException(sprintf('The CommissionInfo property can only contain items of type \rdyescapia\StructType\CommissionInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommissionInfo[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\AgreementsType
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\AgreementsType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\AgreementsType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\AgreementsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
