<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitStayType StructType
 * @subpackage Structs
 */
class UnitStayType extends AbstractStructBase
{
    /**
     * The UnitRates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfUnitStayTypeUnitRate
     */
    public $UnitRates;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\DateTimeSpanType
     */
    public $TimeSpan;
    /**
     * The DepositPayments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TotalType
     */
    public $Total;
    /**
     * The BasicUnitInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\BasicUnitInfoType
     */
    public $BasicUnitInfo;
    /**
     * The RentalAgreement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfParagraphType
     */
    public $RentalAgreement;
    /**
     * The Pets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PetsPoliciesType
     */
    public $Pets;
    /**
     * The UnitInsuranceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitInsuranceInfo
     */
    public $UnitInsuranceInfo;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The PromotionCode
     * @var string
     */
    public $PromotionCode;
    /**
     * Constructor method for UnitStayType
     * @uses UnitStayType::setUnitRates()
     * @uses UnitStayType::setGuestCounts()
     * @uses UnitStayType::setTimeSpan()
     * @uses UnitStayType::setDepositPayments()
     * @uses UnitStayType::setCancelPenalties()
     * @uses UnitStayType::setTotal()
     * @uses UnitStayType::setBasicUnitInfo()
     * @uses UnitStayType::setRentalAgreement()
     * @uses UnitStayType::setPets()
     * @uses UnitStayType::setUnitInsuranceInfo()
     * @uses UnitStayType::setAvailabilityStatus()
     * @uses UnitStayType::setPromotionCode()
     * @param \rdyescapia\ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates
     * @param \rdyescapia\StructType\GuestCountType $guestCounts
     * @param \rdyescapia\StructType\DateTimeSpanType $timeSpan
     * @param \rdyescapia\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @param \rdyescapia\StructType\CancelPenaltiesType $cancelPenalties
     * @param \rdyescapia\StructType\TotalType $total
     * @param \rdyescapia\StructType\BasicUnitInfoType $basicUnitInfo
     * @param \rdyescapia\ArrayType\ArrayOfParagraphType $rentalAgreement
     * @param \rdyescapia\StructType\PetsPoliciesType $pets
     * @param \rdyescapia\StructType\UnitInsuranceInfo $unitInsuranceInfo
     * @param string $availabilityStatus
     * @param string $promotionCode
     */
    public function __construct(\rdyescapia\ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates = null, \rdyescapia\StructType\GuestCountType $guestCounts = null, \rdyescapia\StructType\DateTimeSpanType $timeSpan = null, \rdyescapia\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null, \rdyescapia\StructType\CancelPenaltiesType $cancelPenalties = null, \rdyescapia\StructType\TotalType $total = null, \rdyescapia\StructType\BasicUnitInfoType $basicUnitInfo = null, \rdyescapia\ArrayType\ArrayOfParagraphType $rentalAgreement = null, \rdyescapia\StructType\PetsPoliciesType $pets = null, \rdyescapia\StructType\UnitInsuranceInfo $unitInsuranceInfo = null, $availabilityStatus = null, $promotionCode = null)
    {
        $this
            ->setUnitRates($unitRates)
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setTotal($total)
            ->setBasicUnitInfo($basicUnitInfo)
            ->setRentalAgreement($rentalAgreement)
            ->setPets($pets)
            ->setUnitInsuranceInfo($unitInsuranceInfo)
            ->setAvailabilityStatus($availabilityStatus)
            ->setPromotionCode($promotionCode);
    }
    /**
     * Get UnitRates value
     * @return \rdyescapia\ArrayType\ArrayOfUnitStayTypeUnitRate|null
     */
    public function getUnitRates()
    {
        return $this->UnitRates;
    }
    /**
     * Set UnitRates value
     * @param \rdyescapia\ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setUnitRates(\rdyescapia\ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates = null)
    {
        $this->UnitRates = $unitRates;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \rdyescapia\StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \rdyescapia\StructType\GuestCountType $guestCounts
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setGuestCounts(\rdyescapia\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \rdyescapia\StructType\DateTimeSpanType|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \rdyescapia\StructType\DateTimeSpanType $timeSpan
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setTimeSpan(\rdyescapia\StructType\DateTimeSpanType $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \rdyescapia\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \rdyescapia\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setDepositPayments(\rdyescapia\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \rdyescapia\StructType\CancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \rdyescapia\StructType\CancelPenaltiesType $cancelPenalties
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setCancelPenalties(\rdyescapia\StructType\CancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get Total value
     * @return \rdyescapia\StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \rdyescapia\StructType\TotalType $total
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setTotal(\rdyescapia\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get BasicUnitInfo value
     * @return \rdyescapia\StructType\BasicUnitInfoType|null
     */
    public function getBasicUnitInfo()
    {
        return $this->BasicUnitInfo;
    }
    /**
     * Set BasicUnitInfo value
     * @param \rdyescapia\StructType\BasicUnitInfoType $basicUnitInfo
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setBasicUnitInfo(\rdyescapia\StructType\BasicUnitInfoType $basicUnitInfo = null)
    {
        $this->BasicUnitInfo = $basicUnitInfo;
        return $this;
    }
    /**
     * Get RentalAgreement value
     * @return \rdyescapia\ArrayType\ArrayOfParagraphType|null
     */
    public function getRentalAgreement()
    {
        return $this->RentalAgreement;
    }
    /**
     * Set RentalAgreement value
     * @param \rdyescapia\ArrayType\ArrayOfParagraphType $rentalAgreement
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setRentalAgreement(\rdyescapia\ArrayType\ArrayOfParagraphType $rentalAgreement = null)
    {
        $this->RentalAgreement = $rentalAgreement;
        return $this;
    }
    /**
     * Get Pets value
     * @return \rdyescapia\StructType\PetsPoliciesType|null
     */
    public function getPets()
    {
        return $this->Pets;
    }
    /**
     * Set Pets value
     * @param \rdyescapia\StructType\PetsPoliciesType $pets
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setPets(\rdyescapia\StructType\PetsPoliciesType $pets = null)
    {
        $this->Pets = $pets;
        return $this;
    }
    /**
     * Get UnitInsuranceInfo value
     * @return \rdyescapia\StructType\UnitInsuranceInfo|null
     */
    public function getUnitInsuranceInfo()
    {
        return $this->UnitInsuranceInfo;
    }
    /**
     * Set UnitInsuranceInfo value
     * @param \rdyescapia\StructType\UnitInsuranceInfo $unitInsuranceInfo
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setUnitInsuranceInfo(\rdyescapia\StructType\UnitInsuranceInfo $unitInsuranceInfo = null)
    {
        $this->UnitInsuranceInfo = $unitInsuranceInfo;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \rdyescapia\EnumType\RateIndicatorType::valueIsValid()
     * @uses \rdyescapia\EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\RateIndicatorType', is_array($availabilityStatus) ? implode(', ', $availabilityStatus) : var_export($availabilityStatus, true), implode(', ', \rdyescapia\EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \rdyescapia\StructType\UnitStayType
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitStayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
