<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitHolds StructType
 * @subpackage Structs
 */
class UnitHolds extends AbstractStructBase
{
    /**
     * The UnitHold
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitHolds[]
     */
    public $UnitHold;
    /**
     * The UnitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitCode;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The CreateDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateDateTime;
    /**
     * The Timespan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\DateTimeSpanType
     */
    public $Timespan;
    /**
     * The ID
     * @var int
     */
    public $ID;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * Constructor method for UnitHolds
     * @uses UnitHolds::setUnitHold()
     * @uses UnitHolds::setUnitCode()
     * @uses UnitHolds::setFirstName()
     * @uses UnitHolds::setLastName()
     * @uses UnitHolds::setNotes()
     * @uses UnitHolds::setEmail()
     * @uses UnitHolds::setPhoneNumber()
     * @uses UnitHolds::setCreateDateTime()
     * @uses UnitHolds::setTimespan()
     * @uses UnitHolds::setID()
     * @uses UnitHolds::setType()
     * @uses UnitHolds::setNumber()
     * @param \rdyescapia\StructType\UnitHolds[] $unitHold
     * @param string $unitCode
     * @param string $firstName
     * @param string $lastName
     * @param string $notes
     * @param string $email
     * @param string $phoneNumber
     * @param string $createDateTime
     * @param \rdyescapia\StructType\DateTimeSpanType $timespan
     * @param int $iD
     * @param string $type
     * @param string $number
     */
    public function __construct(array $unitHold = array(), $unitCode = null, $firstName = null, $lastName = null, $notes = null, $email = null, $phoneNumber = null, $createDateTime = null, \rdyescapia\StructType\DateTimeSpanType $timespan = null, $iD = null, $type = null, $number = null)
    {
        $this
            ->setUnitHold($unitHold)
            ->setUnitCode($unitCode)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setNotes($notes)
            ->setEmail($email)
            ->setPhoneNumber($phoneNumber)
            ->setCreateDateTime($createDateTime)
            ->setTimespan($timespan)
            ->setID($iD)
            ->setType($type)
            ->setNumber($number);
    }
    /**
     * Get UnitHold value
     * @return \rdyescapia\StructType\UnitHolds[]|null
     */
    public function getUnitHold()
    {
        return $this->UnitHold;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitHold method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitHold method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitHoldForArrayConstraintsFromSetUnitHold(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitHoldsUnitHoldItem) {
            // validation for constraint: itemType
            if (!$unitHoldsUnitHoldItem instanceof \rdyescapia\StructType\UnitHolds) {
                $invalidValues[] = is_object($unitHoldsUnitHoldItem) ? get_class($unitHoldsUnitHoldItem) : sprintf('%s(%s)', gettype($unitHoldsUnitHoldItem), var_export($unitHoldsUnitHoldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitHold property can only contain items of type \rdyescapia\StructType\UnitHolds, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitHold value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitHolds[] $unitHold
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setUnitHold(array $unitHold = array())
    {
        // validation for constraint: array
        if ('' !== ($unitHoldArrayErrorMessage = self::validateUnitHoldForArrayConstraintsFromSetUnitHold($unitHold))) {
            throw new \InvalidArgumentException($unitHoldArrayErrorMessage, __LINE__);
        }
        $this->UnitHold = $unitHold;
        return $this;
    }
    /**
     * Add item to UnitHold value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitHolds $item
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function addToUnitHold(\rdyescapia\StructType\UnitHolds $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\UnitHolds) {
            throw new \InvalidArgumentException(sprintf('The UnitHold property can only contain items of type \rdyescapia\StructType\UnitHolds, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnitHold[] = $item;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get Timespan value
     * @return \rdyescapia\StructType\DateTimeSpanType|null
     */
    public function getTimespan()
    {
        return $this->Timespan;
    }
    /**
     * Set Timespan value
     * @param \rdyescapia\StructType\DateTimeSpanType $timespan
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setTimespan(\rdyescapia\StructType\DateTimeSpanType $timespan = null)
    {
        $this->Timespan = $timespan;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \rdyescapia\StructType\UnitHolds
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitHolds
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
