<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalType StructType
 * @subpackage Structs
 */
class TotalType extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TaxesType
     */
    public $Taxes;
    /**
     * The AmountBeforeTax
     * @var float
     */
    public $AmountBeforeTax;
    /**
     * The AmountAfterTax
     * @var float
     */
    public $AmountAfterTax;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The AdditionalFeesExcludedIndicator
     * @var bool
     */
    public $AdditionalFeesExcludedIndicator;
    /**
     * Constructor method for TotalType
     * @uses TotalType::setTaxes()
     * @uses TotalType::setAmountBeforeTax()
     * @uses TotalType::setAmountAfterTax()
     * @uses TotalType::setCurrencyCode()
     * @uses TotalType::setDecimalPlaces()
     * @uses TotalType::setAdditionalFeesExcludedIndicator()
     * @param \rdyescapia\StructType\TaxesType $taxes
     * @param float $amountBeforeTax
     * @param float $amountAfterTax
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param bool $additionalFeesExcludedIndicator
     */
    public function __construct(\rdyescapia\StructType\TaxesType $taxes = null, $amountBeforeTax = null, $amountAfterTax = null, $currencyCode = null, $decimalPlaces = null, $additionalFeesExcludedIndicator = null)
    {
        $this
            ->setTaxes($taxes)
            ->setAmountBeforeTax($amountBeforeTax)
            ->setAmountAfterTax($amountAfterTax)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setAdditionalFeesExcludedIndicator($additionalFeesExcludedIndicator);
    }
    /**
     * Get Taxes value
     * @return \rdyescapia\StructType\TaxesType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \rdyescapia\StructType\TaxesType $taxes
     * @return \rdyescapia\StructType\TotalType
     */
    public function setTaxes(\rdyescapia\StructType\TaxesType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get AmountBeforeTax value
     * @return float|null
     */
    public function getAmountBeforeTax()
    {
        return $this->AmountBeforeTax;
    }
    /**
     * Set AmountBeforeTax value
     * @param float $amountBeforeTax
     * @return \rdyescapia\StructType\TotalType
     */
    public function setAmountBeforeTax($amountBeforeTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountBeforeTax) && !(is_float($amountBeforeTax) || is_numeric($amountBeforeTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountBeforeTax, true), gettype($amountBeforeTax)), __LINE__);
        }
        $this->AmountBeforeTax = $amountBeforeTax;
        return $this;
    }
    /**
     * Get AmountAfterTax value
     * @return float|null
     */
    public function getAmountAfterTax()
    {
        return $this->AmountAfterTax;
    }
    /**
     * Set AmountAfterTax value
     * @param float $amountAfterTax
     * @return \rdyescapia\StructType\TotalType
     */
    public function setAmountAfterTax($amountAfterTax = null)
    {
        // validation for constraint: float
        if (!is_null($amountAfterTax) && !(is_float($amountAfterTax) || is_numeric($amountAfterTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountAfterTax, true), gettype($amountAfterTax)), __LINE__);
        }
        $this->AmountAfterTax = $amountAfterTax;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \rdyescapia\StructType\TotalType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \rdyescapia\StructType\TotalType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get AdditionalFeesExcludedIndicator value
     * @return bool|null
     */
    public function getAdditionalFeesExcludedIndicator()
    {
        return $this->AdditionalFeesExcludedIndicator;
    }
    /**
     * Set AdditionalFeesExcludedIndicator value
     * @param bool $additionalFeesExcludedIndicator
     * @return \rdyescapia\StructType\TotalType
     */
    public function setAdditionalFeesExcludedIndicator($additionalFeesExcludedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($additionalFeesExcludedIndicator) && !is_bool($additionalFeesExcludedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($additionalFeesExcludedIndicator, true), gettype($additionalFeesExcludedIndicator)), __LINE__);
        }
        $this->AdditionalFeesExcludedIndicator = $additionalFeesExcludedIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\TotalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
