<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerType StructType
 * @subpackage Structs
 */
class CustomerType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmailType[]
     */
    public $Email;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Address[]
     */
    public $Address;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\URL_Type[]
     */
    public $URL;
    /**
     * The CitizenCountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CitizenCountryName[]
     */
    public $CitizenCountryName;
    /**
     * The PhysChallName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PhysChallName;
    /**
     * The PetInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PetInfo;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PaymentFormType[]
     */
    public $PaymentForm;
    /**
     * The RelatedTraveler
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\RelatedTravelerType[]
     */
    public $RelatedTraveler;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ContactPersonType[]
     */
    public $ContactPerson;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\DocumentType[]
     */
    public $Document;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The EmployeeInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The EmployerInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNameType
     */
    public $EmployerInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The Deceased
     * @var bool
     */
    public $Deceased;
    /**
     * The LockoutType
     * @var string
     */
    public $LockoutType;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The VIP_Indicator
     * @var bool
     */
    public $VIP_Indicator;
    /**
     * Constructor method for CustomerType
     * @uses CustomerType::setPersonName()
     * @uses CustomerType::setTelephone()
     * @uses CustomerType::setEmail()
     * @uses CustomerType::setAddress()
     * @uses CustomerType::setURL()
     * @uses CustomerType::setCitizenCountryName()
     * @uses CustomerType::setPhysChallName()
     * @uses CustomerType::setPetInfo()
     * @uses CustomerType::setPaymentForm()
     * @uses CustomerType::setRelatedTraveler()
     * @uses CustomerType::setContactPerson()
     * @uses CustomerType::setDocument()
     * @uses CustomerType::setCustLoyalty()
     * @uses CustomerType::setEmployeeInfo()
     * @uses CustomerType::setEmployerInfo()
     * @uses CustomerType::setTPA_Extensions()
     * @uses CustomerType::setGender()
     * @uses CustomerType::setDeceased()
     * @uses CustomerType::setLockoutType()
     * @uses CustomerType::setBirthDate()
     * @uses CustomerType::setCurrencyCode()
     * @uses CustomerType::setDecimalPlaces()
     * @uses CustomerType::setVIP_Indicator()
     * @param \rdyescapia\StructType\PersonNameType $personName
     * @param \rdyescapia\StructType\Telephone[] $telephone
     * @param \rdyescapia\StructType\EmailType[] $email
     * @param \rdyescapia\StructType\Address[] $address
     * @param \rdyescapia\StructType\URL_Type[] $uRL
     * @param \rdyescapia\StructType\CitizenCountryName[] $citizenCountryName
     * @param string[] $physChallName
     * @param string[] $petInfo
     * @param \rdyescapia\StructType\PaymentFormType[] $paymentForm
     * @param \rdyescapia\StructType\RelatedTravelerType[] $relatedTraveler
     * @param \rdyescapia\StructType\ContactPersonType[] $contactPerson
     * @param \rdyescapia\StructType\DocumentType[] $document
     * @param \rdyescapia\StructType\CustLoyalty[] $custLoyalty
     * @param \rdyescapia\StructType\EmployeeInfoType[] $employeeInfo
     * @param \rdyescapia\StructType\CompanyNameType $employerInfo
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $gender
     * @param bool $deceased
     * @param string $lockoutType
     * @param string $birthDate
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param bool $vIP_Indicator
     */
    public function __construct(\rdyescapia\StructType\PersonNameType $personName = null, array $telephone = array(), array $email = array(), array $address = array(), array $uRL = array(), array $citizenCountryName = array(), array $physChallName = array(), array $petInfo = array(), array $paymentForm = array(), array $relatedTraveler = array(), array $contactPerson = array(), array $document = array(), array $custLoyalty = array(), array $employeeInfo = array(), \rdyescapia\StructType\CompanyNameType $employerInfo = null, \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null, $gender = null, $deceased = null, $lockoutType = null, $birthDate = null, $currencyCode = null, $decimalPlaces = null, $vIP_Indicator = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setURL($uRL)
            ->setCitizenCountryName($citizenCountryName)
            ->setPhysChallName($physChallName)
            ->setPetInfo($petInfo)
            ->setPaymentForm($paymentForm)
            ->setRelatedTraveler($relatedTraveler)
            ->setContactPerson($contactPerson)
            ->setDocument($document)
            ->setCustLoyalty($custLoyalty)
            ->setEmployeeInfo($employeeInfo)
            ->setEmployerInfo($employerInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setGender($gender)
            ->setDeceased($deceased)
            ->setLockoutType($lockoutType)
            ->setBirthDate($birthDate)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setVIP_Indicator($vIP_Indicator);
    }
    /**
     * Get PersonName value
     * @return \rdyescapia\StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \rdyescapia\StructType\PersonNameType $personName
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setPersonName(\rdyescapia\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \rdyescapia\StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$customerTypeTelephoneItem instanceof \rdyescapia\StructType\Telephone) {
                $invalidValues[] = is_object($customerTypeTelephoneItem) ? get_class($customerTypeTelephoneItem) : sprintf('%s(%s)', gettype($customerTypeTelephoneItem), var_export($customerTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \rdyescapia\StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Telephone[] $telephone
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Telephone $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToTelephone(\rdyescapia\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \rdyescapia\StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \rdyescapia\StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeEmailItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmailItem instanceof \rdyescapia\StructType\EmailType) {
                $invalidValues[] = is_object($customerTypeEmailItem) ? get_class($customerTypeEmailItem) : sprintf('%s(%s)', gettype($customerTypeEmailItem), var_export($customerTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \rdyescapia\StructType\EmailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmailType[] $email
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmailType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToEmail(\rdyescapia\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \rdyescapia\StructType\EmailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \rdyescapia\StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeAddressItem) {
            // validation for constraint: itemType
            if (!$customerTypeAddressItem instanceof \rdyescapia\StructType\Address) {
                $invalidValues[] = is_object($customerTypeAddressItem) ? get_class($customerTypeAddressItem) : sprintf('%s(%s)', gettype($customerTypeAddressItem), var_export($customerTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \rdyescapia\StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Address[] $address
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Address $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToAddress(\rdyescapia\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \rdyescapia\StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \rdyescapia\StructType\URL_Type[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * This method is responsible for validating the values passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateURLForArrayConstraintsFromSetURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeURLItem) {
            // validation for constraint: itemType
            if (!$customerTypeURLItem instanceof \rdyescapia\StructType\URL_Type) {
                $invalidValues[] = is_object($customerTypeURLItem) ? get_class($customerTypeURLItem) : sprintf('%s(%s)', gettype($customerTypeURLItem), var_export($customerTypeURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The URL property can only contain items of type \rdyescapia\StructType\URL_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\URL_Type[] $uRL
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setURL(array $uRL = array())
    {
        // validation for constraint: array
        if ('' !== ($uRLArrayErrorMessage = self::validateURLForArrayConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLArrayErrorMessage, __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\URL_Type $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToURL(\rdyescapia\StructType\URL_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\URL_Type) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of type \rdyescapia\StructType\URL_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \rdyescapia\StructType\CitizenCountryName[]|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * This method is responsible for validating the values passed to the setCitizenCountryName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCitizenCountryName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCitizenCountryNameForArrayConstraintsFromSetCitizenCountryName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeCitizenCountryNameItem) {
            // validation for constraint: itemType
            if (!$customerTypeCitizenCountryNameItem instanceof \rdyescapia\StructType\CitizenCountryName) {
                $invalidValues[] = is_object($customerTypeCitizenCountryNameItem) ? get_class($customerTypeCitizenCountryNameItem) : sprintf('%s(%s)', gettype($customerTypeCitizenCountryNameItem), var_export($customerTypeCitizenCountryNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CitizenCountryName property can only contain items of type \rdyescapia\StructType\CitizenCountryName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CitizenCountryName[] $citizenCountryName
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setCitizenCountryName(array $citizenCountryName = array())
    {
        // validation for constraint: array
        if ('' !== ($citizenCountryNameArrayErrorMessage = self::validateCitizenCountryNameForArrayConstraintsFromSetCitizenCountryName($citizenCountryName))) {
            throw new \InvalidArgumentException($citizenCountryNameArrayErrorMessage, __LINE__);
        }
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Add item to CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CitizenCountryName $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToCitizenCountryName(\rdyescapia\StructType\CitizenCountryName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CitizenCountryName) {
            throw new \InvalidArgumentException(sprintf('The CitizenCountryName property can only contain items of type \rdyescapia\StructType\CitizenCountryName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CitizenCountryName[] = $item;
        return $this;
    }
    /**
     * Get PhysChallName value
     * @return string[]|null
     */
    public function getPhysChallName()
    {
        return $this->PhysChallName;
    }
    /**
     * This method is responsible for validating the values passed to the setPhysChallName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhysChallName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhysChallNameForArrayConstraintsFromSetPhysChallName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePhysChallNameItem) {
            // validation for constraint: itemType
            if (!is_string($customerTypePhysChallNameItem)) {
                $invalidValues[] = is_object($customerTypePhysChallNameItem) ? get_class($customerTypePhysChallNameItem) : sprintf('%s(%s)', gettype($customerTypePhysChallNameItem), var_export($customerTypePhysChallNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhysChallName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhysChallName value
     * @throws \InvalidArgumentException
     * @param string[] $physChallName
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setPhysChallName(array $physChallName = array())
    {
        // validation for constraint: array
        if ('' !== ($physChallNameArrayErrorMessage = self::validatePhysChallNameForArrayConstraintsFromSetPhysChallName($physChallName))) {
            throw new \InvalidArgumentException($physChallNameArrayErrorMessage, __LINE__);
        }
        $this->PhysChallName = $physChallName;
        return $this;
    }
    /**
     * Add item to PhysChallName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToPhysChallName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PhysChallName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PhysChallName[] = $item;
        return $this;
    }
    /**
     * Get PetInfo value
     * @return string[]|null
     */
    public function getPetInfo()
    {
        return $this->PetInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPetInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPetInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePetInfoForArrayConstraintsFromSetPetInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePetInfoItem) {
            // validation for constraint: itemType
            if (!is_string($customerTypePetInfoItem)) {
                $invalidValues[] = is_object($customerTypePetInfoItem) ? get_class($customerTypePetInfoItem) : sprintf('%s(%s)', gettype($customerTypePetInfoItem), var_export($customerTypePetInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PetInfo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PetInfo value
     * @throws \InvalidArgumentException
     * @param string[] $petInfo
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setPetInfo(array $petInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($petInfoArrayErrorMessage = self::validatePetInfoForArrayConstraintsFromSetPetInfo($petInfo))) {
            throw new \InvalidArgumentException($petInfoArrayErrorMessage, __LINE__);
        }
        $this->PetInfo = $petInfo;
        return $this;
    }
    /**
     * Add item to PetInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToPetInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PetInfo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PetInfo[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \rdyescapia\StructType\PaymentFormType[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentForm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentForm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormForArrayConstraintsFromSetPaymentForm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePaymentFormItem) {
            // validation for constraint: itemType
            if (!$customerTypePaymentFormItem instanceof \rdyescapia\StructType\PaymentFormType) {
                $invalidValues[] = is_object($customerTypePaymentFormItem) ? get_class($customerTypePaymentFormItem) : sprintf('%s(%s)', gettype($customerTypePaymentFormItem), var_export($customerTypePaymentFormItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentForm property can only contain items of type \rdyescapia\StructType\PaymentFormType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormType[] $paymentForm
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormArrayErrorMessage = self::validatePaymentFormForArrayConstraintsFromSetPaymentForm($paymentForm))) {
            throw new \InvalidArgumentException($paymentFormArrayErrorMessage, __LINE__);
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToPaymentForm(\rdyescapia\StructType\PaymentFormType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PaymentFormType) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of type \rdyescapia\StructType\PaymentFormType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get RelatedTraveler value
     * @return \rdyescapia\StructType\RelatedTravelerType[]|null
     */
    public function getRelatedTraveler()
    {
        return $this->RelatedTraveler;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedTraveler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedTraveler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedTravelerForArrayConstraintsFromSetRelatedTraveler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeRelatedTravelerItem) {
            // validation for constraint: itemType
            if (!$customerTypeRelatedTravelerItem instanceof \rdyescapia\StructType\RelatedTravelerType) {
                $invalidValues[] = is_object($customerTypeRelatedTravelerItem) ? get_class($customerTypeRelatedTravelerItem) : sprintf('%s(%s)', gettype($customerTypeRelatedTravelerItem), var_export($customerTypeRelatedTravelerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedTraveler property can only contain items of type \rdyescapia\StructType\RelatedTravelerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\RelatedTravelerType[] $relatedTraveler
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setRelatedTraveler(array $relatedTraveler = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedTravelerArrayErrorMessage = self::validateRelatedTravelerForArrayConstraintsFromSetRelatedTraveler($relatedTraveler))) {
            throw new \InvalidArgumentException($relatedTravelerArrayErrorMessage, __LINE__);
        }
        $this->RelatedTraveler = $relatedTraveler;
        return $this;
    }
    /**
     * Add item to RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\RelatedTravelerType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToRelatedTraveler(\rdyescapia\StructType\RelatedTravelerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\RelatedTravelerType) {
            throw new \InvalidArgumentException(sprintf('The RelatedTraveler property can only contain items of type \rdyescapia\StructType\RelatedTravelerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatedTraveler[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return \rdyescapia\StructType\ContactPersonType[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * This method is responsible for validating the values passed to the setContactPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactPersonForArrayConstraintsFromSetContactPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeContactPersonItem) {
            // validation for constraint: itemType
            if (!$customerTypeContactPersonItem instanceof \rdyescapia\StructType\ContactPersonType) {
                $invalidValues[] = is_object($customerTypeContactPersonItem) ? get_class($customerTypeContactPersonItem) : sprintf('%s(%s)', gettype($customerTypeContactPersonItem), var_export($customerTypeContactPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactPerson property can only contain items of type \rdyescapia\StructType\ContactPersonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ContactPersonType[] $contactPerson
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($contactPersonArrayErrorMessage = self::validateContactPersonForArrayConstraintsFromSetContactPerson($contactPerson))) {
            throw new \InvalidArgumentException($contactPersonArrayErrorMessage, __LINE__);
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ContactPersonType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToContactPerson(\rdyescapia\StructType\ContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\ContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of type \rdyescapia\StructType\ContactPersonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return \rdyescapia\StructType\DocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$customerTypeDocumentItem instanceof \rdyescapia\StructType\DocumentType) {
                $invalidValues[] = is_object($customerTypeDocumentItem) ? get_class($customerTypeDocumentItem) : sprintf('%s(%s)', gettype($customerTypeDocumentItem), var_export($customerTypeDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \rdyescapia\StructType\DocumentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\DocumentType[] $document
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\DocumentType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToDocument(\rdyescapia\StructType\DocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\DocumentType) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \rdyescapia\StructType\DocumentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \rdyescapia\StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$customerTypeCustLoyaltyItem instanceof \rdyescapia\StructType\CustLoyalty) {
                $invalidValues[] = is_object($customerTypeCustLoyaltyItem) ? get_class($customerTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($customerTypeCustLoyaltyItem), var_export($customerTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \rdyescapia\StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CustLoyalty[] $custLoyalty
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CustLoyalty $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToCustLoyalty(\rdyescapia\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \rdyescapia\StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \rdyescapia\StructType\EmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmployeeInfoItem instanceof \rdyescapia\StructType\EmployeeInfoType) {
                $invalidValues[] = is_object($customerTypeEmployeeInfoItem) ? get_class($customerTypeEmployeeInfoItem) : sprintf('%s(%s)', gettype($customerTypeEmployeeInfoItem), var_export($customerTypeEmployeeInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmployeeInfo property can only contain items of type \rdyescapia\StructType\EmployeeInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmployeeInfoType[] $employeeInfo
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeInfoArrayErrorMessage = self::validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo($employeeInfo))) {
            throw new \InvalidArgumentException($employeeInfoArrayErrorMessage, __LINE__);
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmployeeInfoType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToEmployeeInfo(\rdyescapia\StructType\EmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of type \rdyescapia\StructType\EmployeeInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get EmployerInfo value
     * @return \rdyescapia\StructType\CompanyNameType|null
     */
    public function getEmployerInfo()
    {
        return $this->EmployerInfo;
    }
    /**
     * Set EmployerInfo value
     * @param \rdyescapia\StructType\CompanyNameType $employerInfo
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setEmployerInfo(\rdyescapia\StructType\CompanyNameType $employerInfo = null)
    {
        $this->EmployerInfo = $employerInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Deceased value
     * @return bool|null
     */
    public function getDeceased()
    {
        return $this->Deceased;
    }
    /**
     * Set Deceased value
     * @param bool $deceased
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setDeceased($deceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($deceased) && !is_bool($deceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deceased, true), gettype($deceased)), __LINE__);
        }
        $this->Deceased = $deceased;
        return $this;
    }
    /**
     * Get LockoutType value
     * @return string|null
     */
    public function getLockoutType()
    {
        return $this->LockoutType;
    }
    /**
     * Set LockoutType value
     * @param string $lockoutType
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setLockoutType($lockoutType = null)
    {
        // validation for constraint: string
        if (!is_null($lockoutType) && !is_string($lockoutType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockoutType, true), gettype($lockoutType)), __LINE__);
        }
        $this->LockoutType = $lockoutType;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get VIP_Indicator value
     * @return bool|null
     */
    public function getVIP_Indicator()
    {
        return $this->VIP_Indicator;
    }
    /**
     * Set VIP_Indicator value
     * @param bool $vIP_Indicator
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setVIP_Indicator($vIP_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($vIP_Indicator) && !is_bool($vIP_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vIP_Indicator, true), gettype($vIP_Indicator)), __LINE__);
        }
        $this->VIP_Indicator = $vIP_Indicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\CustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
