<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonPrefType StructType
 * @subpackage Structs
 */
class CommonPrefType extends AbstractStructBase
{
    /**
     * The NamePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\NamePrefType[]
     */
    public $NamePref;
    /**
     * The PhonePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PhonePrefType[]
     */
    public $PhonePref;
    /**
     * The AddressPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AddressPrefType[]
     */
    public $AddressPref;
    /**
     * The PaymentFormPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The InterestPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\InterestPrefType[]
     */
    public $InterestPref;
    /**
     * The InsurancePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\InsurancePrefType[]
     */
    public $InsurancePref;
    /**
     * The SeatingPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SeatingPrefType[]
     */
    public $SeatingPref;
    /**
     * The TicketDistribPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TicketDistribPrefType[]
     */
    public $TicketDistribPref;
    /**
     * The MediaEntertainPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\MediaEntertainPrefType[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PetInfoPrefType[]
     */
    public $PetInfoPref;
    /**
     * The MealPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\MealPrefType[]
     */
    public $MealPref;
    /**
     * The LoyaltyPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\LoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The SpecRequestPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The RelatedTravelerPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\RelatedTravelerPrefType[]
     */
    public $RelatedTravelerPref;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The SmokingAllowed
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * Constructor method for CommonPrefType
     * @uses CommonPrefType::setNamePref()
     * @uses CommonPrefType::setPhonePref()
     * @uses CommonPrefType::setAddressPref()
     * @uses CommonPrefType::setPaymentFormPref()
     * @uses CommonPrefType::setInterestPref()
     * @uses CommonPrefType::setInsurancePref()
     * @uses CommonPrefType::setSeatingPref()
     * @uses CommonPrefType::setTicketDistribPref()
     * @uses CommonPrefType::setMediaEntertainPref()
     * @uses CommonPrefType::setPetInfoPref()
     * @uses CommonPrefType::setMealPref()
     * @uses CommonPrefType::setLoyaltyPref()
     * @uses CommonPrefType::setSpecRequestPref()
     * @uses CommonPrefType::setRelatedTravelerPref()
     * @uses CommonPrefType::setTPA_Extensions()
     * @uses CommonPrefType::setShareSynchInd()
     * @uses CommonPrefType::setShareMarketInd()
     * @uses CommonPrefType::setSmokingAllowed()
     * @uses CommonPrefType::setPrimaryLangID()
     * @uses CommonPrefType::setAltLangID()
     * @param \rdyescapia\StructType\NamePrefType[] $namePref
     * @param \rdyescapia\StructType\PhonePrefType[] $phonePref
     * @param \rdyescapia\StructType\AddressPrefType[] $addressPref
     * @param \rdyescapia\StructType\PaymentFormPrefType[] $paymentFormPref
     * @param \rdyescapia\StructType\InterestPrefType[] $interestPref
     * @param \rdyescapia\StructType\InsurancePrefType[] $insurancePref
     * @param \rdyescapia\StructType\SeatingPrefType[] $seatingPref
     * @param \rdyescapia\StructType\TicketDistribPrefType[] $ticketDistribPref
     * @param \rdyescapia\StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @param \rdyescapia\StructType\PetInfoPrefType[] $petInfoPref
     * @param \rdyescapia\StructType\MealPrefType[] $mealPref
     * @param \rdyescapia\StructType\LoyaltyPrefType[] $loyaltyPref
     * @param \rdyescapia\StructType\SpecRequestPrefType[] $specRequestPref
     * @param \rdyescapia\StructType\RelatedTravelerPrefType[] $relatedTravelerPref
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $smokingAllowed
     * @param string $primaryLangID
     * @param string $altLangID
     */
    public function __construct(array $namePref = array(), array $phonePref = array(), array $addressPref = array(), array $paymentFormPref = array(), array $interestPref = array(), array $insurancePref = array(), array $seatingPref = array(), array $ticketDistribPref = array(), array $mediaEntertainPref = array(), array $petInfoPref = array(), array $mealPref = array(), array $loyaltyPref = array(), array $specRequestPref = array(), array $relatedTravelerPref = array(), \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null, $smokingAllowed = false, $primaryLangID = null, $altLangID = null)
    {
        $this
            ->setNamePref($namePref)
            ->setPhonePref($phonePref)
            ->setAddressPref($addressPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setInterestPref($interestPref)
            ->setInsurancePref($insurancePref)
            ->setSeatingPref($seatingPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setMealPref($mealPref)
            ->setLoyaltyPref($loyaltyPref)
            ->setSpecRequestPref($specRequestPref)
            ->setRelatedTravelerPref($relatedTravelerPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setSmokingAllowed($smokingAllowed)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID);
    }
    /**
     * Get NamePref value
     * @return \rdyescapia\StructType\NamePrefType[]|null
     */
    public function getNamePref()
    {
        return $this->NamePref;
    }
    /**
     * This method is responsible for validating the values passed to the setNamePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNamePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNamePrefForArrayConstraintsFromSetNamePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeNamePrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeNamePrefItem instanceof \rdyescapia\StructType\NamePrefType) {
                $invalidValues[] = is_object($commonPrefTypeNamePrefItem) ? get_class($commonPrefTypeNamePrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeNamePrefItem), var_export($commonPrefTypeNamePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NamePref property can only contain items of type \rdyescapia\StructType\NamePrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NamePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\NamePrefType[] $namePref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setNamePref(array $namePref = array())
    {
        // validation for constraint: array
        if ('' !== ($namePrefArrayErrorMessage = self::validateNamePrefForArrayConstraintsFromSetNamePref($namePref))) {
            throw new \InvalidArgumentException($namePrefArrayErrorMessage, __LINE__);
        }
        $this->NamePref = $namePref;
        return $this;
    }
    /**
     * Add item to NamePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\NamePrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToNamePref(\rdyescapia\StructType\NamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\NamePrefType) {
            throw new \InvalidArgumentException(sprintf('The NamePref property can only contain items of type \rdyescapia\StructType\NamePrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NamePref[] = $item;
        return $this;
    }
    /**
     * Get PhonePref value
     * @return \rdyescapia\StructType\PhonePrefType[]|null
     */
    public function getPhonePref()
    {
        return $this->PhonePref;
    }
    /**
     * This method is responsible for validating the values passed to the setPhonePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhonePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhonePrefForArrayConstraintsFromSetPhonePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypePhonePrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypePhonePrefItem instanceof \rdyescapia\StructType\PhonePrefType) {
                $invalidValues[] = is_object($commonPrefTypePhonePrefItem) ? get_class($commonPrefTypePhonePrefItem) : sprintf('%s(%s)', gettype($commonPrefTypePhonePrefItem), var_export($commonPrefTypePhonePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhonePref property can only contain items of type \rdyescapia\StructType\PhonePrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhonePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PhonePrefType[] $phonePref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setPhonePref(array $phonePref = array())
    {
        // validation for constraint: array
        if ('' !== ($phonePrefArrayErrorMessage = self::validatePhonePrefForArrayConstraintsFromSetPhonePref($phonePref))) {
            throw new \InvalidArgumentException($phonePrefArrayErrorMessage, __LINE__);
        }
        $this->PhonePref = $phonePref;
        return $this;
    }
    /**
     * Add item to PhonePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PhonePrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToPhonePref(\rdyescapia\StructType\PhonePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PhonePrefType) {
            throw new \InvalidArgumentException(sprintf('The PhonePref property can only contain items of type \rdyescapia\StructType\PhonePrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PhonePref[] = $item;
        return $this;
    }
    /**
     * Get AddressPref value
     * @return \rdyescapia\StructType\AddressPrefType[]|null
     */
    public function getAddressPref()
    {
        return $this->AddressPref;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressPrefForArrayConstraintsFromSetAddressPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeAddressPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeAddressPrefItem instanceof \rdyescapia\StructType\AddressPrefType) {
                $invalidValues[] = is_object($commonPrefTypeAddressPrefItem) ? get_class($commonPrefTypeAddressPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeAddressPrefItem), var_export($commonPrefTypeAddressPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressPref property can only contain items of type \rdyescapia\StructType\AddressPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AddressPrefType[] $addressPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setAddressPref(array $addressPref = array())
    {
        // validation for constraint: array
        if ('' !== ($addressPrefArrayErrorMessage = self::validateAddressPrefForArrayConstraintsFromSetAddressPref($addressPref))) {
            throw new \InvalidArgumentException($addressPrefArrayErrorMessage, __LINE__);
        }
        $this->AddressPref = $addressPref;
        return $this;
    }
    /**
     * Add item to AddressPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AddressPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToAddressPref(\rdyescapia\StructType\AddressPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AddressPrefType) {
            throw new \InvalidArgumentException(sprintf('The AddressPref property can only contain items of type \rdyescapia\StructType\AddressPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \rdyescapia\StructType\PaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFormPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFormPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypePaymentFormPrefItem instanceof \rdyescapia\StructType\PaymentFormPrefType) {
                $invalidValues[] = is_object($commonPrefTypePaymentFormPrefItem) ? get_class($commonPrefTypePaymentFormPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypePaymentFormPrefItem), var_export($commonPrefTypePaymentFormPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFormPref property can only contain items of type \rdyescapia\StructType\PaymentFormPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormPrefType[] $paymentFormPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormPrefArrayErrorMessage = self::validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref($paymentFormPref))) {
            throw new \InvalidArgumentException($paymentFormPrefArrayErrorMessage, __LINE__);
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToPaymentFormPref(\rdyescapia\StructType\PaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of type \rdyescapia\StructType\PaymentFormPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get InterestPref value
     * @return \rdyescapia\StructType\InterestPrefType[]|null
     */
    public function getInterestPref()
    {
        return $this->InterestPref;
    }
    /**
     * This method is responsible for validating the values passed to the setInterestPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterestPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterestPrefForArrayConstraintsFromSetInterestPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeInterestPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeInterestPrefItem instanceof \rdyescapia\StructType\InterestPrefType) {
                $invalidValues[] = is_object($commonPrefTypeInterestPrefItem) ? get_class($commonPrefTypeInterestPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeInterestPrefItem), var_export($commonPrefTypeInterestPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InterestPref property can only contain items of type \rdyescapia\StructType\InterestPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InterestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\InterestPrefType[] $interestPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setInterestPref(array $interestPref = array())
    {
        // validation for constraint: array
        if ('' !== ($interestPrefArrayErrorMessage = self::validateInterestPrefForArrayConstraintsFromSetInterestPref($interestPref))) {
            throw new \InvalidArgumentException($interestPrefArrayErrorMessage, __LINE__);
        }
        $this->InterestPref = $interestPref;
        return $this;
    }
    /**
     * Add item to InterestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\InterestPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToInterestPref(\rdyescapia\StructType\InterestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\InterestPrefType) {
            throw new \InvalidArgumentException(sprintf('The InterestPref property can only contain items of type \rdyescapia\StructType\InterestPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InterestPref[] = $item;
        return $this;
    }
    /**
     * Get InsurancePref value
     * @return \rdyescapia\StructType\InsurancePrefType[]|null
     */
    public function getInsurancePref()
    {
        return $this->InsurancePref;
    }
    /**
     * This method is responsible for validating the values passed to the setInsurancePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsurancePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsurancePrefForArrayConstraintsFromSetInsurancePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeInsurancePrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeInsurancePrefItem instanceof \rdyescapia\StructType\InsurancePrefType) {
                $invalidValues[] = is_object($commonPrefTypeInsurancePrefItem) ? get_class($commonPrefTypeInsurancePrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeInsurancePrefItem), var_export($commonPrefTypeInsurancePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InsurancePref property can only contain items of type \rdyescapia\StructType\InsurancePrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InsurancePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\InsurancePrefType[] $insurancePref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setInsurancePref(array $insurancePref = array())
    {
        // validation for constraint: array
        if ('' !== ($insurancePrefArrayErrorMessage = self::validateInsurancePrefForArrayConstraintsFromSetInsurancePref($insurancePref))) {
            throw new \InvalidArgumentException($insurancePrefArrayErrorMessage, __LINE__);
        }
        $this->InsurancePref = $insurancePref;
        return $this;
    }
    /**
     * Add item to InsurancePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\InsurancePrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToInsurancePref(\rdyescapia\StructType\InsurancePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\InsurancePrefType) {
            throw new \InvalidArgumentException(sprintf('The InsurancePref property can only contain items of type \rdyescapia\StructType\InsurancePrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InsurancePref[] = $item;
        return $this;
    }
    /**
     * Get SeatingPref value
     * @return \rdyescapia\StructType\SeatingPrefType[]|null
     */
    public function getSeatingPref()
    {
        return $this->SeatingPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatingPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatingPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatingPrefForArrayConstraintsFromSetSeatingPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeSeatingPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeSeatingPrefItem instanceof \rdyescapia\StructType\SeatingPrefType) {
                $invalidValues[] = is_object($commonPrefTypeSeatingPrefItem) ? get_class($commonPrefTypeSeatingPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeSeatingPrefItem), var_export($commonPrefTypeSeatingPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatingPref property can only contain items of type \rdyescapia\StructType\SeatingPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatingPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SeatingPrefType[] $seatingPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setSeatingPref(array $seatingPref = array())
    {
        // validation for constraint: array
        if ('' !== ($seatingPrefArrayErrorMessage = self::validateSeatingPrefForArrayConstraintsFromSetSeatingPref($seatingPref))) {
            throw new \InvalidArgumentException($seatingPrefArrayErrorMessage, __LINE__);
        }
        $this->SeatingPref = $seatingPref;
        return $this;
    }
    /**
     * Add item to SeatingPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SeatingPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToSeatingPref(\rdyescapia\StructType\SeatingPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SeatingPrefType) {
            throw new \InvalidArgumentException(sprintf('The SeatingPref property can only contain items of type \rdyescapia\StructType\SeatingPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatingPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \rdyescapia\StructType\TicketDistribPrefType[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDistribPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDistribPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeTicketDistribPrefItem instanceof \rdyescapia\StructType\TicketDistribPrefType) {
                $invalidValues[] = is_object($commonPrefTypeTicketDistribPrefItem) ? get_class($commonPrefTypeTicketDistribPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeTicketDistribPrefItem), var_export($commonPrefTypeTicketDistribPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDistribPref property can only contain items of type \rdyescapia\StructType\TicketDistribPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TicketDistribPrefType[] $ticketDistribPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDistribPrefArrayErrorMessage = self::validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref($ticketDistribPref))) {
            throw new \InvalidArgumentException($ticketDistribPrefArrayErrorMessage, __LINE__);
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TicketDistribPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToTicketDistribPref(\rdyescapia\StructType\TicketDistribPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TicketDistribPrefType) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of type \rdyescapia\StructType\TicketDistribPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return \rdyescapia\StructType\MediaEntertainPrefType[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaEntertainPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaEntertainPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaEntertainPrefForArrayConstraintsFromSetMediaEntertainPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeMediaEntertainPrefItem instanceof \rdyescapia\StructType\MediaEntertainPrefType) {
                $invalidValues[] = is_object($commonPrefTypeMediaEntertainPrefItem) ? get_class($commonPrefTypeMediaEntertainPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeMediaEntertainPrefItem), var_export($commonPrefTypeMediaEntertainPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MediaEntertainPref property can only contain items of type \rdyescapia\StructType\MediaEntertainPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaEntertainPrefArrayErrorMessage = self::validateMediaEntertainPrefForArrayConstraintsFromSetMediaEntertainPref($mediaEntertainPref))) {
            throw new \InvalidArgumentException($mediaEntertainPrefArrayErrorMessage, __LINE__);
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MediaEntertainPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToMediaEntertainPref(\rdyescapia\StructType\MediaEntertainPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\MediaEntertainPrefType) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of type \rdyescapia\StructType\MediaEntertainPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return \rdyescapia\StructType\PetInfoPrefType[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPetInfoPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPetInfoPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePetInfoPrefForArrayConstraintsFromSetPetInfoPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypePetInfoPrefItem instanceof \rdyescapia\StructType\PetInfoPrefType) {
                $invalidValues[] = is_object($commonPrefTypePetInfoPrefItem) ? get_class($commonPrefTypePetInfoPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypePetInfoPrefItem), var_export($commonPrefTypePetInfoPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PetInfoPref property can only contain items of type \rdyescapia\StructType\PetInfoPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PetInfoPrefType[] $petInfoPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        // validation for constraint: array
        if ('' !== ($petInfoPrefArrayErrorMessage = self::validatePetInfoPrefForArrayConstraintsFromSetPetInfoPref($petInfoPref))) {
            throw new \InvalidArgumentException($petInfoPrefArrayErrorMessage, __LINE__);
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PetInfoPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToPetInfoPref(\rdyescapia\StructType\PetInfoPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PetInfoPrefType) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of type \rdyescapia\StructType\PetInfoPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return \rdyescapia\StructType\MealPrefType[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * This method is responsible for validating the values passed to the setMealPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMealPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMealPrefForArrayConstraintsFromSetMealPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeMealPrefItem instanceof \rdyescapia\StructType\MealPrefType) {
                $invalidValues[] = is_object($commonPrefTypeMealPrefItem) ? get_class($commonPrefTypeMealPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeMealPrefItem), var_export($commonPrefTypeMealPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MealPref property can only contain items of type \rdyescapia\StructType\MealPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MealPrefType[] $mealPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        // validation for constraint: array
        if ('' !== ($mealPrefArrayErrorMessage = self::validateMealPrefForArrayConstraintsFromSetMealPref($mealPref))) {
            throw new \InvalidArgumentException($mealPrefArrayErrorMessage, __LINE__);
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MealPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToMealPref(\rdyescapia\StructType\MealPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\MealPrefType) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of type \rdyescapia\StructType\MealPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyPref value
     * @return \rdyescapia\StructType\LoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeLoyaltyPrefItem instanceof \rdyescapia\StructType\LoyaltyPrefType) {
                $invalidValues[] = is_object($commonPrefTypeLoyaltyPrefItem) ? get_class($commonPrefTypeLoyaltyPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeLoyaltyPrefItem), var_export($commonPrefTypeLoyaltyPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyPref property can only contain items of type \rdyescapia\StructType\LoyaltyPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyPrefType[] $loyaltyPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyPrefArrayErrorMessage = self::validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref($loyaltyPref))) {
            throw new \InvalidArgumentException($loyaltyPrefArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToLoyaltyPref(\rdyescapia\StructType\LoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\LoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of type \rdyescapia\StructType\LoyaltyPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \rdyescapia\StructType\SpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecRequestPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecRequestPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeSpecRequestPrefItem instanceof \rdyescapia\StructType\SpecRequestPrefType) {
                $invalidValues[] = is_object($commonPrefTypeSpecRequestPrefItem) ? get_class($commonPrefTypeSpecRequestPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeSpecRequestPrefItem), var_export($commonPrefTypeSpecRequestPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecRequestPref property can only contain items of type \rdyescapia\StructType\SpecRequestPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecRequestPrefType[] $specRequestPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specRequestPrefArrayErrorMessage = self::validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref($specRequestPref))) {
            throw new \InvalidArgumentException($specRequestPrefArrayErrorMessage, __LINE__);
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecRequestPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToSpecRequestPref(\rdyescapia\StructType\SpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of type \rdyescapia\StructType\SpecRequestPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get RelatedTravelerPref value
     * @return \rdyescapia\StructType\RelatedTravelerPrefType[]|null
     */
    public function getRelatedTravelerPref()
    {
        return $this->RelatedTravelerPref;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedTravelerPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedTravelerPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedTravelerPrefForArrayConstraintsFromSetRelatedTravelerPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeRelatedTravelerPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeRelatedTravelerPrefItem instanceof \rdyescapia\StructType\RelatedTravelerPrefType) {
                $invalidValues[] = is_object($commonPrefTypeRelatedTravelerPrefItem) ? get_class($commonPrefTypeRelatedTravelerPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeRelatedTravelerPrefItem), var_export($commonPrefTypeRelatedTravelerPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedTravelerPref property can only contain items of type \rdyescapia\StructType\RelatedTravelerPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedTravelerPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\RelatedTravelerPrefType[] $relatedTravelerPref
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setRelatedTravelerPref(array $relatedTravelerPref = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedTravelerPrefArrayErrorMessage = self::validateRelatedTravelerPrefForArrayConstraintsFromSetRelatedTravelerPref($relatedTravelerPref))) {
            throw new \InvalidArgumentException($relatedTravelerPrefArrayErrorMessage, __LINE__);
        }
        $this->RelatedTravelerPref = $relatedTravelerPref;
        return $this;
    }
    /**
     * Add item to RelatedTravelerPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\RelatedTravelerPrefType $item
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function addToRelatedTravelerPref(\rdyescapia\StructType\RelatedTravelerPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\RelatedTravelerPrefType) {
            throw new \InvalidArgumentException(sprintf('The RelatedTravelerPref property can only contain items of type \rdyescapia\StructType\RelatedTravelerPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatedTravelerPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLangID) && !is_string($primaryLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryLangID, true), gettype($primaryLangID)), __LINE__);
        }
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public function setAltLangID($altLangID = null)
    {
        // validation for constraint: string
        if (!is_null($altLangID) && !is_string($altLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altLangID, true), gettype($altLangID)), __LINE__);
        }
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\CommonPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
