<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPenaltyType StructType
 * @subpackage Structs
 */
class CancelPenaltyType extends AbstractStructBase
{
    /**
     * The Deadline
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Deadline
     */
    public $Deadline;
    /**
     * The AmountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AmountPercentType
     */
    public $AmountPercent;
    /**
     * The PenaltyDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ParagraphType[]
     */
    public $PenaltyDescription;
    /**
     * The ConfirmClassCode
     * @var string
     */
    public $ConfirmClassCode;
    /**
     * The PolicyCode
     * @var string
     */
    public $PolicyCode;
    /**
     * The NonRefundable
     * @var bool
     */
    public $NonRefundable;
    /**
     * The Mon
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * @var bool
     */
    public $Tue;
    /**
     * The Weds
     * @var bool
     */
    public $Weds;
    /**
     * The Thur
     * @var bool
     */
    public $Thur;
    /**
     * The Fri
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * @var bool
     */
    public $Sat;
    /**
     * The Sun
     * @var bool
     */
    public $Sun;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Release
     * @var string
     */
    public $Release;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * Constructor method for CancelPenaltyType
     * @uses CancelPenaltyType::setDeadline()
     * @uses CancelPenaltyType::setAmountPercent()
     * @uses CancelPenaltyType::setPenaltyDescription()
     * @uses CancelPenaltyType::setConfirmClassCode()
     * @uses CancelPenaltyType::setPolicyCode()
     * @uses CancelPenaltyType::setNonRefundable()
     * @uses CancelPenaltyType::setMon()
     * @uses CancelPenaltyType::setTue()
     * @uses CancelPenaltyType::setWeds()
     * @uses CancelPenaltyType::setThur()
     * @uses CancelPenaltyType::setFri()
     * @uses CancelPenaltyType::setSat()
     * @uses CancelPenaltyType::setSun()
     * @uses CancelPenaltyType::setStart()
     * @uses CancelPenaltyType::setDuration()
     * @uses CancelPenaltyType::setEnd()
     * @uses CancelPenaltyType::setRelease()
     * @uses CancelPenaltyType::setRoomTypeCode()
     * @param \rdyescapia\StructType\Deadline $deadline
     * @param \rdyescapia\StructType\AmountPercentType $amountPercent
     * @param \rdyescapia\StructType\ParagraphType[] $penaltyDescription
     * @param string $confirmClassCode
     * @param string $policyCode
     * @param bool $nonRefundable
     * @param bool $mon
     * @param bool $tue
     * @param bool $weds
     * @param bool $thur
     * @param bool $fri
     * @param bool $sat
     * @param bool $sun
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $release
     * @param string $roomTypeCode
     */
    public function __construct(\rdyescapia\StructType\Deadline $deadline = null, \rdyescapia\StructType\AmountPercentType $amountPercent = null, array $penaltyDescription = array(), $confirmClassCode = null, $policyCode = null, $nonRefundable = null, $mon = null, $tue = null, $weds = null, $thur = null, $fri = null, $sat = null, $sun = null, $start = null, $duration = null, $end = null, $release = null, $roomTypeCode = null)
    {
        $this
            ->setDeadline($deadline)
            ->setAmountPercent($amountPercent)
            ->setPenaltyDescription($penaltyDescription)
            ->setConfirmClassCode($confirmClassCode)
            ->setPolicyCode($policyCode)
            ->setNonRefundable($nonRefundable)
            ->setMon($mon)
            ->setTue($tue)
            ->setWeds($weds)
            ->setThur($thur)
            ->setFri($fri)
            ->setSat($sat)
            ->setSun($sun)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRelease($release)
            ->setRoomTypeCode($roomTypeCode);
    }
    /**
     * Get Deadline value
     * @return \rdyescapia\StructType\Deadline|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * Set Deadline value
     * @param \rdyescapia\StructType\Deadline $deadline
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setDeadline(\rdyescapia\StructType\Deadline $deadline = null)
    {
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Get AmountPercent value
     * @return \rdyescapia\StructType\AmountPercentType|null
     */
    public function getAmountPercent()
    {
        return $this->AmountPercent;
    }
    /**
     * Set AmountPercent value
     * @param \rdyescapia\StructType\AmountPercentType $amountPercent
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setAmountPercent(\rdyescapia\StructType\AmountPercentType $amountPercent = null)
    {
        $this->AmountPercent = $amountPercent;
        return $this;
    }
    /**
     * Get PenaltyDescription value
     * @return \rdyescapia\StructType\ParagraphType[]|null
     */
    public function getPenaltyDescription()
    {
        return $this->PenaltyDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyDescriptionForArrayConstraintsFromSetPenaltyDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelPenaltyTypePenaltyDescriptionItem) {
            // validation for constraint: itemType
            if (!$cancelPenaltyTypePenaltyDescriptionItem instanceof \rdyescapia\StructType\ParagraphType) {
                $invalidValues[] = is_object($cancelPenaltyTypePenaltyDescriptionItem) ? get_class($cancelPenaltyTypePenaltyDescriptionItem) : sprintf('%s(%s)', gettype($cancelPenaltyTypePenaltyDescriptionItem), var_export($cancelPenaltyTypePenaltyDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyDescription property can only contain items of type \rdyescapia\StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyDescription value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ParagraphType[] $penaltyDescription
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setPenaltyDescription(array $penaltyDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyDescriptionArrayErrorMessage = self::validatePenaltyDescriptionForArrayConstraintsFromSetPenaltyDescription($penaltyDescription))) {
            throw new \InvalidArgumentException($penaltyDescriptionArrayErrorMessage, __LINE__);
        }
        $this->PenaltyDescription = $penaltyDescription;
        return $this;
    }
    /**
     * Add item to PenaltyDescription value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ParagraphType $item
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function addToPenaltyDescription(\rdyescapia\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The PenaltyDescription property can only contain items of type \rdyescapia\StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyDescription[] = $item;
        return $this;
    }
    /**
     * Get ConfirmClassCode value
     * @return string|null
     */
    public function getConfirmClassCode()
    {
        return $this->ConfirmClassCode;
    }
    /**
     * Set ConfirmClassCode value
     * @param string $confirmClassCode
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setConfirmClassCode($confirmClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($confirmClassCode) && !is_string($confirmClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmClassCode, true), gettype($confirmClassCode)), __LINE__);
        }
        $this->ConfirmClassCode = $confirmClassCode;
        return $this;
    }
    /**
     * Get PolicyCode value
     * @return string|null
     */
    public function getPolicyCode()
    {
        return $this->PolicyCode;
    }
    /**
     * Set PolicyCode value
     * @param string $policyCode
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setPolicyCode($policyCode = null)
    {
        // validation for constraint: string
        if (!is_null($policyCode) && !is_string($policyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyCode, true), gettype($policyCode)), __LINE__);
        }
        $this->PolicyCode = $policyCode;
        return $this;
    }
    /**
     * Get NonRefundable value
     * @return bool|null
     */
    public function getNonRefundable()
    {
        return $this->NonRefundable;
    }
    /**
     * Set NonRefundable value
     * @param bool $nonRefundable
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setNonRefundable($nonRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundable) && !is_bool($nonRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundable, true), gettype($nonRefundable)), __LINE__);
        }
        $this->NonRefundable = $nonRefundable;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool|null
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mon, true), gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool|null
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tue, true), gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Weds value
     * @return bool|null
     */
    public function getWeds()
    {
        return $this->Weds;
    }
    /**
     * Set Weds value
     * @param bool $weds
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setWeds($weds = null)
    {
        // validation for constraint: boolean
        if (!is_null($weds) && !is_bool($weds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($weds, true), gettype($weds)), __LINE__);
        }
        $this->Weds = $weds;
        return $this;
    }
    /**
     * Get Thur value
     * @return bool|null
     */
    public function getThur()
    {
        return $this->Thur;
    }
    /**
     * Set Thur value
     * @param bool $thur
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setThur($thur = null)
    {
        // validation for constraint: boolean
        if (!is_null($thur) && !is_bool($thur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thur, true), gettype($thur)), __LINE__);
        }
        $this->Thur = $thur;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool|null
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fri, true), gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool|null
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sat, true), gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool|null
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sun, true), gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Release value
     * @return string|null
     */
    public function getRelease()
    {
        return $this->Release;
    }
    /**
     * Set Release value
     * @param string $release
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setRelease($release = null)
    {
        // validation for constraint: string
        if (!is_null($release) && !is_string($release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($release, true), gettype($release)), __LINE__);
        }
        $this->Release = $release;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\CancelPenaltyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
