<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalGuestAmountType StructType
 * @subpackage Structs
 */
class AdditionalGuestAmountType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TotalType
     */
    public $Amount;
    /**
     * The AddlGuestAmtDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ParagraphType[]
     */
    public $AddlGuestAmtDescription;
    /**
     * The MaxAdditionalGuests
     * @var int
     */
    public $MaxAdditionalGuests;
    /**
     * The AgeQualifyingCode
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for AdditionalGuestAmountType
     * @uses AdditionalGuestAmountType::setAmount()
     * @uses AdditionalGuestAmountType::setAddlGuestAmtDescription()
     * @uses AdditionalGuestAmountType::setMaxAdditionalGuests()
     * @uses AdditionalGuestAmountType::setAgeQualifyingCode()
     * @uses AdditionalGuestAmountType::setMinAge()
     * @uses AdditionalGuestAmountType::setMaxAge()
     * @uses AdditionalGuestAmountType::setAgeTimeUnit()
     * @uses AdditionalGuestAmountType::setType()
     * @uses AdditionalGuestAmountType::setPercent()
     * @uses AdditionalGuestAmountType::setRPH()
     * @param \rdyescapia\StructType\TotalType $amount
     * @param \rdyescapia\StructType\ParagraphType[] $addlGuestAmtDescription
     * @param int $maxAdditionalGuests
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     * @param string $type
     * @param float $percent
     * @param string $rPH
     */
    public function __construct(\rdyescapia\StructType\TotalType $amount = null, array $addlGuestAmtDescription = array(), $maxAdditionalGuests = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null, $type = null, $percent = null, $rPH = null)
    {
        $this
            ->setAmount($amount)
            ->setAddlGuestAmtDescription($addlGuestAmtDescription)
            ->setMaxAdditionalGuests($maxAdditionalGuests)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit)
            ->setType($type)
            ->setPercent($percent)
            ->setRPH($rPH);
    }
    /**
     * Get Amount value
     * @return \rdyescapia\StructType\TotalType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \rdyescapia\StructType\TotalType $amount
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function setAmount(\rdyescapia\StructType\TotalType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AddlGuestAmtDescription value
     * @return \rdyescapia\StructType\ParagraphType[]|null
     */
    public function getAddlGuestAmtDescription()
    {
        return $this->AddlGuestAmtDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setAddlGuestAmtDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddlGuestAmtDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddlGuestAmtDescriptionForArrayConstraintsFromSetAddlGuestAmtDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalGuestAmountTypeAddlGuestAmtDescriptionItem) {
            // validation for constraint: itemType
            if (!$additionalGuestAmountTypeAddlGuestAmtDescriptionItem instanceof \rdyescapia\StructType\ParagraphType) {
                $invalidValues[] = is_object($additionalGuestAmountTypeAddlGuestAmtDescriptionItem) ? get_class($additionalGuestAmountTypeAddlGuestAmtDescriptionItem) : sprintf('%s(%s)', gettype($additionalGuestAmountTypeAddlGuestAmtDescriptionItem), var_export($additionalGuestAmountTypeAddlGuestAmtDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddlGuestAmtDescription property can only contain items of type \rdyescapia\StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ParagraphType[] $addlGuestAmtDescription
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function setAddlGuestAmtDescription(array $addlGuestAmtDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($addlGuestAmtDescriptionArrayErrorMessage = self::validateAddlGuestAmtDescriptionForArrayConstraintsFromSetAddlGuestAmtDescription($addlGuestAmtDescription))) {
            throw new \InvalidArgumentException($addlGuestAmtDescriptionArrayErrorMessage, __LINE__);
        }
        $this->AddlGuestAmtDescription = $addlGuestAmtDescription;
        return $this;
    }
    /**
     * Add item to AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ParagraphType $item
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function addToAddlGuestAmtDescription(\rdyescapia\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The AddlGuestAmtDescription property can only contain items of type \rdyescapia\StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddlGuestAmtDescription[] = $item;
        return $this;
    }
    /**
     * Get MaxAdditionalGuests value
     * @return int|null
     */
    public function getMaxAdditionalGuests()
    {
        return $this->MaxAdditionalGuests;
    }
    /**
     * Set MaxAdditionalGuests value
     * @param int $maxAdditionalGuests
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function setMaxAdditionalGuests($maxAdditionalGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdditionalGuests) && !(is_int($maxAdditionalGuests) || ctype_digit($maxAdditionalGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAdditionalGuests, true), gettype($maxAdditionalGuests)), __LINE__);
        }
        $this->MaxAdditionalGuests = $maxAdditionalGuests;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \rdyescapia\EnumType\TimeUnitType::valueIsValid()
     * @uses \rdyescapia\EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\TimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\TimeUnitType', is_array($ageTimeUnit) ? implode(', ', $ageTimeUnit) : var_export($ageTimeUnit, true), implode(', ', \rdyescapia\EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\AdditionalGuestAmountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
