<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrganizationType StructType
 * @subpackage Structs
 */
class OrganizationType extends AbstractStructBase
{
    /**
     * The OrgMemberName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\OrgMemberName
     */
    public $OrgMemberName;
    /**
     * The OrgName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNameType
     */
    public $OrgName;
    /**
     * The RelatedOrgName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNameType[]
     */
    public $RelatedOrgName;
    /**
     * The TravelArranger
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The OfficeType
     * @var string
     */
    public $OfficeType;
    /**
     * Constructor method for OrganizationType
     * @uses OrganizationType::setOrgMemberName()
     * @uses OrganizationType::setOrgName()
     * @uses OrganizationType::setRelatedOrgName()
     * @uses OrganizationType::setTravelArranger()
     * @uses OrganizationType::setDefaultInd()
     * @uses OrganizationType::setShareSynchInd()
     * @uses OrganizationType::setShareMarketInd()
     * @uses OrganizationType::setEffectiveDate()
     * @uses OrganizationType::setExpireDate()
     * @uses OrganizationType::setOfficeType()
     * @param \rdyescapia\StructType\OrgMemberName $orgMemberName
     * @param \rdyescapia\StructType\CompanyNameType $orgName
     * @param \rdyescapia\StructType\CompanyNameType[] $relatedOrgName
     * @param \rdyescapia\StructType\TravelArrangerType[] $travelArranger
     * @param bool $defaultInd
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $officeType
     */
    public function __construct(\rdyescapia\StructType\OrgMemberName $orgMemberName = null, \rdyescapia\StructType\CompanyNameType $orgName = null, array $relatedOrgName = array(), array $travelArranger = array(), $defaultInd = false, $shareSynchInd = null, $shareMarketInd = null, $effectiveDate = null, $expireDate = null, $officeType = null)
    {
        $this
            ->setOrgMemberName($orgMemberName)
            ->setOrgName($orgName)
            ->setRelatedOrgName($relatedOrgName)
            ->setTravelArranger($travelArranger)
            ->setDefaultInd($defaultInd)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setOfficeType($officeType);
    }
    /**
     * Get OrgMemberName value
     * @return \rdyescapia\StructType\OrgMemberName|null
     */
    public function getOrgMemberName()
    {
        return $this->OrgMemberName;
    }
    /**
     * Set OrgMemberName value
     * @param \rdyescapia\StructType\OrgMemberName $orgMemberName
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function setOrgMemberName(\rdyescapia\StructType\OrgMemberName $orgMemberName = null)
    {
        $this->OrgMemberName = $orgMemberName;
        return $this;
    }
    /**
     * Get OrgName value
     * @return \rdyescapia\StructType\CompanyNameType|null
     */
    public function getOrgName()
    {
        return $this->OrgName;
    }
    /**
     * Set OrgName value
     * @param \rdyescapia\StructType\CompanyNameType $orgName
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function setOrgName(\rdyescapia\StructType\CompanyNameType $orgName = null)
    {
        $this->OrgName = $orgName;
        return $this;
    }
    /**
     * Get RelatedOrgName value
     * @return \rdyescapia\StructType\CompanyNameType[]|null
     */
    public function getRelatedOrgName()
    {
        return $this->RelatedOrgName;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedOrgName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedOrgName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedOrgNameForArrayConstraintsFromSetRelatedOrgName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organizationTypeRelatedOrgNameItem) {
            // validation for constraint: itemType
            if (!$organizationTypeRelatedOrgNameItem instanceof \rdyescapia\StructType\CompanyNameType) {
                $invalidValues[] = is_object($organizationTypeRelatedOrgNameItem) ? get_class($organizationTypeRelatedOrgNameItem) : sprintf('%s(%s)', gettype($organizationTypeRelatedOrgNameItem), var_export($organizationTypeRelatedOrgNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedOrgName property can only contain items of type \rdyescapia\StructType\CompanyNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedOrgName value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNameType[] $relatedOrgName
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function setRelatedOrgName(array $relatedOrgName = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedOrgNameArrayErrorMessage = self::validateRelatedOrgNameForArrayConstraintsFromSetRelatedOrgName($relatedOrgName))) {
            throw new \InvalidArgumentException($relatedOrgNameArrayErrorMessage, __LINE__);
        }
        $this->RelatedOrgName = $relatedOrgName;
        return $this;
    }
    /**
     * Add item to RelatedOrgName value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNameType $item
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function addToRelatedOrgName(\rdyescapia\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The RelatedOrgName property can only contain items of type \rdyescapia\StructType\CompanyNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatedOrgName[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \rdyescapia\StructType\TravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelArranger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelArranger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelArrangerForArrayConstraintsFromSetTravelArranger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organizationTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$organizationTypeTravelArrangerItem instanceof \rdyescapia\StructType\TravelArrangerType) {
                $invalidValues[] = is_object($organizationTypeTravelArrangerItem) ? get_class($organizationTypeTravelArrangerItem) : sprintf('%s(%s)', gettype($organizationTypeTravelArrangerItem), var_export($organizationTypeTravelArrangerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelArranger property can only contain items of type \rdyescapia\StructType\TravelArrangerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TravelArrangerType[] $travelArranger
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        // validation for constraint: array
        if ('' !== ($travelArrangerArrayErrorMessage = self::validateTravelArrangerForArrayConstraintsFromSetTravelArranger($travelArranger))) {
            throw new \InvalidArgumentException($travelArrangerArrayErrorMessage, __LINE__);
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TravelArrangerType $item
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function addToTravelArranger(\rdyescapia\StructType\TravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of type \rdyescapia\StructType\TravelArrangerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function setDefaultInd($defaultInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get OfficeType value
     * @return string|null
     */
    public function getOfficeType()
    {
        return $this->OfficeType;
    }
    /**
     * Set OfficeType value
     * @uses \rdyescapia\EnumType\OfficeLocationType::valueIsValid()
     * @uses \rdyescapia\EnumType\OfficeLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $officeType
     * @return \rdyescapia\StructType\OrganizationType
     */
    public function setOfficeType($officeType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\OfficeLocationType::valueIsValid($officeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\OfficeLocationType', is_array($officeType) ? implode(', ', $officeType) : var_export($officeType, true), implode(', ', \rdyescapia\EnumType\OfficeLocationType::getValidValues())), __LINE__);
        }
        $this->OfficeType = $officeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\OrganizationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
