<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AreaType StructType
 * @subpackage Structs
 */
class AreaType extends AbstractStructBase
{
    /**
     * The AreaDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ParagraphType
     */
    public $AreaDescription;
    /**
     * The AreaID
     * @var string
     */
    public $AreaID;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The CityCode
     * @var string
     */
    public $CityCode;
    /**
     * The StateProv
     * @var string
     */
    public $StateProv;
    /**
     * The StateProvCode
     * @var string
     */
    public $StateProvCode;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for AreaType
     * @uses AreaType::setAreaDescription()
     * @uses AreaType::setAreaID()
     * @uses AreaType::setCity()
     * @uses AreaType::setCityCode()
     * @uses AreaType::setStateProv()
     * @uses AreaType::setStateProvCode()
     * @uses AreaType::setCountryCode()
     * @param \rdyescapia\StructType\ParagraphType $areaDescription
     * @param string $areaID
     * @param string $city
     * @param string $cityCode
     * @param string $stateProv
     * @param string $stateProvCode
     * @param string $countryCode
     */
    public function __construct(\rdyescapia\StructType\ParagraphType $areaDescription = null, $areaID = null, $city = null, $cityCode = null, $stateProv = null, $stateProvCode = null, $countryCode = null)
    {
        $this
            ->setAreaDescription($areaDescription)
            ->setAreaID($areaID)
            ->setCity($city)
            ->setCityCode($cityCode)
            ->setStateProv($stateProv)
            ->setStateProvCode($stateProvCode)
            ->setCountryCode($countryCode);
    }
    /**
     * Get AreaDescription value
     * @return \rdyescapia\StructType\ParagraphType|null
     */
    public function getAreaDescription()
    {
        return $this->AreaDescription;
    }
    /**
     * Set AreaDescription value
     * @param \rdyescapia\StructType\ParagraphType $areaDescription
     * @return \rdyescapia\StructType\AreaType
     */
    public function setAreaDescription(\rdyescapia\StructType\ParagraphType $areaDescription = null)
    {
        $this->AreaDescription = $areaDescription;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \rdyescapia\StructType\AreaType
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \rdyescapia\StructType\AreaType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \rdyescapia\StructType\AreaType
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityCode, true), gettype($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get StateProv value
     * @return string|null
     */
    public function getStateProv()
    {
        return $this->StateProv;
    }
    /**
     * Set StateProv value
     * @param string $stateProv
     * @return \rdyescapia\StructType\AreaType
     */
    public function setStateProv($stateProv = null)
    {
        // validation for constraint: string
        if (!is_null($stateProv) && !is_string($stateProv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProv, true), gettype($stateProv)), __LINE__);
        }
        $this->StateProv = $stateProv;
        return $this;
    }
    /**
     * Get StateProvCode value
     * @return string|null
     */
    public function getStateProvCode()
    {
        return $this->StateProvCode;
    }
    /**
     * Set StateProvCode value
     * @param string $stateProvCode
     * @return \rdyescapia\StructType\AreaType
     */
    public function setStateProvCode($stateProvCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvCode) && !is_string($stateProvCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvCode, true), gettype($stateProvCode)), __LINE__);
        }
        $this->StateProvCode = $stateProvCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \rdyescapia\StructType\AreaType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\AreaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
